/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.base.util;

import com.cgd.common.exception.BusinessException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlManageDom4jUtils {
    private static final Logger LOG = LoggerFactory.getLogger(XmlManageDom4jUtils.class);
    public static final String SERVICE_XML = "-service.xml";
    public static final String DESCRIPTION = "description";
    public static final String IMPL = ".impl";

    private XmlManageDom4jUtils() {
        throw new UnsupportedOperationException("\u5de5\u5177\u7c7b\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static void changeMqXmlFromAToB(String a, String b) {
        String path = System.getProperty("user.dir").replace("\\", "/") + "/src/main/resources/spring";
        File file = new File(path);
        File[] tempList = file.listFiles();
        if (tempList != null) {
            for (File f : tempList) {
                if (!f.getName().contains("-" + a + "-")) continue;
                String newPath = f.getPath().replace("-" + a + "-", "-" + b + "-");
                try {
                    XmlManageDom4jUtils.changeMQXml(f.getPath(), newPath);
                }
                catch (Exception e) {
                    LOG.error("\u8f6c\u6362\u751f\u4ea7\u8005\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010" + f.getPath() + "\u3011", (Throwable)e);
                }
            }
        }
    }

    public static void transformationServiceXmlToHsf() {
        File[] tempList;
        String basePath = System.getProperty("user.dir").replace("\\", "/");
        LOG.info("Base path is " + basePath);
        basePath = basePath.substring(0, basePath.lastIndexOf("/"));
        File file = new File(basePath);
        for (File f : tempList = file.listFiles()) {
            String projectName = f.getName();
            if (!projectName.contains("-api") || projectName.contains("timedtask")) continue;
            if (projectName.equals("business_commodity-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_commodity-center");
            }
            if (projectName.equals("business_systemmanage-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_commodity-center");
            }
            if (projectName.equals("business_order-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_order-center");
            }
            if (projectName.equals("electricity_supplier_comm-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/electricity_supplier_comm-center");
            }
            if (projectName.equals("electricity_supplier_pay-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/electricity_supplier_pay-center");
            }
            if (projectName.equals("electricity_supplier_order-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/electricity_supplier_order-center");
            }
            if (projectName.equals("business_pay-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_pay-center");
            }
            if (projectName.equals("business_systemmanage-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_pay-center");
            }
            if (projectName.equals("workflow-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/workflow-center");
            }
            if (projectName.equals("business_user-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_user-center");
            }
            if (projectName.equals("business_inquiry-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/business_inquiry-center");
            }
            if (projectName.equals("cgd_business_commodity-api")) {
                XmlManageDom4jUtils.generateHsfXml(basePath + "/cgd_business_commodity-center");
            }
            LOG.info("generate " + projectName + " hsf config file success!");
        }
    }

    public static void generateHsfXml(String basePath) {
        String path = basePath + "/src/main/resources/spring";
        File file = new File(path);
        File[] tempList = file.listFiles();
        if (tempList != null) {
            for (File f : tempList) {
                String fName = f.getName();
                if (!fName.contains(SERVICE_XML) || !fName.contains("-busi") && !fName.contains("-intfce")) continue;
                String cBasePath = basePath.replace("-center", "");
                String pPath = "";
                String cPath = "";
                pPath = basePath + "/src/main/resources/spring/" + fName.replace(SERVICE_XML, "-phsf.xml");
                cPath = cBasePath + "-api/src/main/resources/spring/" + fName.replace(SERVICE_XML, "-chsf.xml");
                try {
                    XmlManageDom4jUtils.transformationService(f.getPath(), cPath, pPath, fName);
                }
                catch (Exception e) {
                    LOG.error("\u751f\u6210hsf\u914d\u7f6e\u6587\u4ef6\u51fa\u9519\uff01\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6\u3010" + f.getPath() + "\u3011", (Throwable)e);
                }
            }
        }
    }

    private static void transformationService(String path, String cPath, String pPath, String fileName) {
        String[] fs = fileName.split("-");
        String projectName = fs[1];
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(new File(path));
        }
        catch (DocumentException e) {
            LOG.error("xml\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff01", (Throwable)e);
            throw new BusinessException("8888", e.getMessage());
        }
        Element node = document.getRootElement();
        String description = node.element(DESCRIPTION).getText();
        Document cdoc = DocumentHelper.createDocument();
        Element cbeans = cdoc.addElement("beans", "http://www.springframework.org/schema/beans");
        Document pdoc = DocumentHelper.createDocument();
        Element pbeans = pdoc.addElement("beans", "http://www.springframework.org/schema/beans");
        cbeans.addElement(DESCRIPTION).setText(description.replace("service", "hsf\u670d\u52a1\u8c03\u7528\u8005"));
        pbeans.addElement(DESCRIPTION).setText(description.replace("service", "hsf\u670d\u52a1\u63d0\u4f9b\u8005"));
        XmlManageDom4jUtils.setNamespace(cbeans);
        XmlManageDom4jUtils.setNamespace(pbeans);
        List list = node.elements("bean");
        for (Element e : list) {
            String id = e.attributeValue("id");
            String className = null;
            try {
                className = e.attributeValue("class");
                className = className.contains("ExceptionInfoServiceImpl") ? "com.cgd.common.cache.service.CacheExecuterService" : ((className = className.substring(0, className.length() - 4)).contains("electricitysupplier.busi.impl") ? className.replace(IMPL, "") : (className.contains("com.cgd.inquiry.busi") ? className.replace(IMPL, "") : className.substring(0, className.indexOf(IMPL)) + className.substring(className.lastIndexOf("."), className.length())));
                XmlManageDom4jUtils.setHsfProvider(pbeans, id, className, projectName, null);
                XmlManageDom4jUtils.setHsfConsumer(cbeans, id, className, projectName, null);
            }
            catch (Exception e1) {
                LOG.error("\u751f\u6210hsf\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u63a5\u53e3" + className, (Throwable)e1);
            }
        }
        XmlManageDom4jUtils.writer(cdoc, cPath);
        XmlManageDom4jUtils.writer(pdoc, pPath);
    }

    private static void setNamespace(Element beans) {
        beans.addNamespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        beans.addNamespace("context", "http://www.springframework.org/schema/context");
        beans.addNamespace("hsf", "http://www.taobao.com/hsf");
        beans.addAttribute("xsi:schemaLocation", "http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://www.springframework.org/schema/context http://www.springframework.org/schema/context/spring-context.xsd http://www.taobao.com/hsf  http://www.taobao.com/hsf/hsf.xsd ");
    }

    private static void setHsfConsumer(Element beans, String id, String className, String projectName, Set<String> chsfEspecialConfig) {
        Element hsfBean = beans.addElement("hsf:consumer");
        hsfBean.addAttribute("id", id);
        hsfBean.addAttribute("interface", className);
        hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
        hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
        hsfBean.addAttribute("clientTimeout", "60000");
        if (projectName.contains("inquiry")) {
            hsfBean.addAttribute("target", "${" + projectName.toUpperCase() + "_TARGET_IP}");
        } else {
            hsfBean.addAttribute("target", "${" + projectName.toUpperCase() + "TARGET_IP}");
        }
        if (CollectionUtils.isNotEmpty(chsfEspecialConfig)) {
            for (String config : chsfEspecialConfig) {
                String[] keyValue = config.split("=");
                hsfBean.addAttribute(keyValue[0], keyValue[1]);
            }
        }
    }

    private static void setHsfProvider(Element beans, String id, String className, String projectName, Set<String> phsfEspecialConfig) {
        Element hsfBean = beans.addElement("hsf:provider");
        hsfBean.addAttribute("id", id + "H");
        hsfBean.addAttribute("interface", className);
        hsfBean.addAttribute("ref", id);
        hsfBean.addAttribute("version", "${" + projectName.toUpperCase() + "_VERSION}");
        hsfBean.addAttribute("group", "${" + projectName.toUpperCase() + "_GROUP}");
        hsfBean.addAttribute("clientTimeout", "60000");
        hsfBean.addAttribute("enableTXC", "true");
        hsfBean.addAttribute("serializeType", "hessian");
        if (CollectionUtils.isNotEmpty(phsfEspecialConfig)) {
            for (String config : phsfEspecialConfig) {
                String[] keyValue = config.split("=");
                hsfBean.addAttribute(keyValue[0], keyValue[1]);
            }
        }
    }

    private static void changeMQXml(String path, String newPath) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(new File(path));
        }
        catch (DocumentException e) {
            LOG.error("\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\u8bef", (Throwable)e);
            throw new BusinessException("8888", e.getMessage());
        }
        Element node = document.getRootElement();
        List list = node.elements("bean");
        for (Element e : list) {
            String value;
            Attribute attr = e.attribute("class");
            switch (value = attr.getValue()) {
                case "com.cgd.base.mq.rocketmq.OnsProducerImpl": {
                    attr.setValue("com.cgd.base.mq.ons.OnsProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.rocketmq.BaseProducerImpl": {
                    attr.setValue("com.cgd.base.mq.ons.BaseProducerImpl");
                    break;
                }
                case "com.cgd.base.mq.rocketmq.OnsTransProducerImpl": {
                    attr.setValue("com.cgd.base.mq.ons.OnsTransProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.rocketmq.MQLocalTransactionExecuter": {
                    attr.setValue("com.cgd.base.mq.ons.ONSLocalTransactionExecuter");
                    break;
                }
                case "com.cgd.base.mq.ons.OnsProducerImpl": {
                    attr.setValue("com.cgd.base.mq.rocketmq.OnsProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.ons.BaseProducerImpl": {
                    attr.setValue("com.cgd.base.mq.rocketmq.BaseProducerImpl");
                    break;
                }
                case "com.cgd.base.mq.ons.OnsTransProducerImpl": {
                    attr.setValue("com.cgd.base.mq.rocketmq.OnsTransProducerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.ons.ONSLocalTransactionExecuter": {
                    attr.setValue("com.cgd.base.mq.rocketmq.MQLocalTransactionExecuter");
                    break;
                }
                case "com.cgd.base.mq.rocketmq.BaseConsumerImpl": {
                    attr.setValue("com.cgd.base.mq.ons.BaseConsumerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.rocketmq.ConsumerProerties": {
                    attr.setValue("com.cgd.base.mq.ons.ConsumerProerties");
                    break;
                }
                case "com.cgd.base.mq.rocketmq.MQCunsumerImpl": {
                    attr.setValue("com.cgd.base.mq.ons.ONSCunsumerImpl");
                    break;
                }
                case "com.cgd.base.mq.ons.BaseConsumerImpl": {
                    attr.setValue("com.cgd.base.mq.rocketmq.BaseConsumerImpl");
                    XmlManageDom4jUtils.changeProducerPropes(e);
                    break;
                }
                case "com.cgd.base.mq.ons.ConsumerProerties": {
                    attr.setValue("com.cgd.base.mq.rocketmq.ConsumerProerties");
                    break;
                }
                case "com.cgd.base.mq.ons.ONSCunsumerImpl": {
                    attr.setValue("com.cgd.base.mq.rocketmq.MQCunsumerImpl");
                    break;
                }
            }
        }
        XmlManageDom4jUtils.writer(document, newPath);
    }

    private static void changeProducerPropes(Element e) {
        Element constructor = e.element("constructor-arg");
        if (constructor != null) {
            XmlManageDom4jUtils.changeProps(constructor);
        } else {
            List propertys = e.elements("property");
            for (Element property : propertys) {
                String nameValue = property.attributeValue("name");
                if (!"properties".equals(nameValue)) continue;
                XmlManageDom4jUtils.changeProps(property);
                break;
            }
        }
    }

    private static void changeProps(Element elem) {
        Element props = elem.element("props");
        List prolist = props.elements("prop");
        for (Element pe : prolist) {
            Attribute pattr = pe.attribute("key");
            String pValue = pattr.getValue();
            if ("NAMESRV_ADDR".equals(pValue)) {
                pattr.setValue("AccessKey");
                pe.setText("${ons.AccessKey}");
                Element prop = props.addElement("prop");
                prop.addAttribute("key", "SecretKey");
                prop.setText("${ons.SecretKey}");
                continue;
            }
            if ("AccessKey".equals(pValue)) {
                pattr.setValue("NAMESRV_ADDR");
                pe.setText("${mq.NAMESRV_ADDR}");
                continue;
            }
            if (!"SecretKey".equals(pValue)) continue;
            props.remove(pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writer(Document document, String newPath) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        File file = new File(newPath);
        XMLWriter writer = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
            writer = new XMLWriter((Writer)outputStreamWriter, format);
            if (writer != null) {
                writer.flush();
                writer.write(document);
            }
        }
        catch (FileNotFoundException e) {
            LOG.error("\u6587\u4ef6\u4e0d\u5b58\u5728|", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("\u6587\u4ef6IO\u5f02\u5e38|", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                LOG.error("writer\u5173\u95ed\u5f02\u5e38|", (Throwable)e);
            }
        }
    }
}

