/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.aop;

import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.ResourceException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;

public class ExceptionAdvisor
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionAdvisor.class);
    private CacheService cacheService;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> objClass = method.getReturnType();
        LOG.info("\u4e8b\u52a1\u5f00\u59cb...");
        Object object = null;
        try {
            object = pjp.proceed();
            this.putCodeToRsp(object, "0000", "\u64cd\u4f5c\u6210\u529f\uff01", true);
            return object;
        }
        catch (ResourceException e) {
            LOG.error("\u4e1a\u52a1\u5f02\u5e38  ", (Throwable)e);
            object = objClass.newInstance();
            String msgCode = e.getMsgCode();
            if (msgCode == null || "".equals(msgCode)) {
                if (e.getCause() instanceof ResourceException) {
                    msgCode = e.getMsgCode();
                }
                if (msgCode == null || "".equals(msgCode)) {
                    msgCode = "8888";
                }
            }
            LOG.debug("\u6700\u7ec8\u9519\u8bef\u7f16\u7801={}", (Object)msgCode);
            this.putCodeToRsp(object, msgCode, e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("\u7cfb\u7edf\u5f02\u5e38  ", e);
            object = objClass.newInstance();
            this.putCodeToRsp(object, "8888", "\u7cfb\u7edf\u5f02\u5e38\uff01");
        }
        LOG.info("\u4e8b\u52a1\u7ed3\u675f...");
        return object;
    }

    private void putCodeToRsp(Object object, String code, String desc) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.putCodeToRsp(object, code, desc, false);
    }

    private void putCodeToRsp(Object object, String code, String desc, boolean fource) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        LOG.debug("putCodeToRsp code={},desc={},fource", new Object[]{code, desc, fource});
        if (object instanceof RspInfoBO) {
            Field field = RspInfoBO.class.getDeclaredField("respCode");
            field.setAccessible(true);
            if (field.get(object) == null) {
                field.set(object, code);
                field = RspInfoBO.class.getDeclaredField("respDesc");
                field.setAccessible(true);
                field.set(object, desc);
            }
        }
    }

    public int getOrder() {
        return 100;
    }
}

