/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.util;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import java.util.Collection;
import java.util.Properties;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class BasePropertyConfigurer
implements FactoryBean<Properties>,
InitializingBean {
    private boolean singleton = true;
    private String namespace;
    private Properties singletonInstance;

    public final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public Properties getObject() throws Exception {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.createProperties();
    }

    public Class<Properties> getObjectType() {
        return Properties.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.singleton) {
            this.singletonInstance = this.createProperties();
        }
    }

    private Properties createProperties() {
        Properties result = new Properties();
        Config config = ConfigService.getAppConfig();
        if (config == null) {
            return result;
        }
        if (CollectionUtils.isEmpty((Collection)config.getPropertyNames())) {
            return result;
        }
        if (this.namespace != null) {
            Config nameConfig = ConfigService.getConfig((String)this.namespace);
            nameConfig.getPropertyNames().stream().forEach(key -> result.setProperty((String)key, nameConfig.getProperty(key, "")));
        }
        config.getPropertyNames().stream().forEach(key -> result.setProperty((String)key, config.getProperty(key, "")));
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }
}

