/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.util;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.consumer.ConcurrentLoggingConsumer;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenorUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SenorUtil.class);
    final ISensorsAnalytics sa;

    public SenorUtil(String logPath, int size) {
        this.sa = new SensorsAnalytics((Consumer)new ConcurrentLoggingConsumer(logPath, size));
    }

    public SenorUtil(String logPath) {
        this.sa = new SensorsAnalytics((Consumer)new ConcurrentLoggingConsumer(logPath));
    }

    public void pushPublicPro(boolean isLogin) throws InvalidArgumentException {
        SuperPropertiesRecord superPropertiesRecord = SuperPropertiesRecord.builder().addProperty("app_name", "\u7535\u5b50\u8d85\u5e02").addProperty("is_vip", false).addProperty("vip_level", "\u666e\u901a\u4f1a\u5458").addProperty("all_is_login", isLogin).build();
        this.sa.registerSuperProperties(superPropertiesRecord);
    }

    public void trackSignUp(String cookieId, String registerId, Map<String, Object> map) {
        try {
            this.pushPublicPro(true);
            EventRecord eventRecord = EventRecord.builder().setDistinctId(registerId).isLoginId(Boolean.valueOf(true)).setEventName("dzcsLoginResult").addProperties(map).build();
            this.sa.track(eventRecord);
            this.sa.trackSignUp(registerId, cookieId);
        }
        catch (Exception ex) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-\u795e\u7b56API]-\u4e0a\u62a5\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5f02\u5e38\uff5c", (Throwable)ex);
        }
    }

    public void track(String distinctId, boolean isLogin, String eventName, Map<String, Object> map) {
        try {
            this.pushPublicPro(isLogin);
            EventRecord eventRecord = EventRecord.builder().setDistinctId(distinctId).isLoginId(Boolean.valueOf(isLogin)).setEventName(eventName).addProperties(map).build();
            this.sa.track(eventRecord);
        }
        catch (Exception ex) {
            LOG.error("[\u57fa\u7840\u7ec4\u4ef6-\u795e\u7b56API]-\u4e0a\u62a5\u4fe1\u606f\u5f02\u5e38\uff5c", (Throwable)ex);
        }
    }
}

