/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.pay.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelFile {
    private static final Logger logger = LoggerFactory.getLogger(ExcelFile.class);
    private boolean isXlsxMode = false;
    private Workbook workbook;
    private List<SheetInfo> sheets = new ArrayList<SheetInfo>();
    private Map<Integer, List<CellFormater>> sheetCellFormat = new HashMap<Integer, List<CellFormater>>();
    private String errMsg;
    private int lastSheetIndex;
    private int lastRowIndex;
    private int lastCellIndex;

    public String getLastCellLocation() {
        return "Sheet=" + this.lastSheetIndex + ",Row=" + this.lastRowIndex + ",Cell=" + this.lastCellIndex;
    }

    public ExcelFile() {
        this.isXlsxMode = false;
        this.createWorkBook(null);
    }

    public ExcelFile(boolean xlsxMode) {
        this.isXlsxMode = xlsxMode;
        this.createWorkBook(null);
    }

    public static ExcelFile ofStreamed() {
        ExcelFile instance = new ExcelFile();
        instance.workbook = new SXSSFWorkbook();
        return instance;
    }

    public ExcelFile(InputStream is) {
        try {
            this.initOnLoad(is);
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            logger.error("Load excel failed when from InputStream ," + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelFile(InputStream is, boolean xlsxMode) {
        this.isXlsxMode = xlsxMode;
        try {
            this.initOnLoad(is);
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            logger.error("Load excel failed when from InputStream ," + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelFile(String fileName, boolean xlsxMode) {
        this.isXlsxMode = xlsxMode;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.initOnLoad(fis);
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            logger.error("Load excel failed when from file,file=" + fileName, (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelFile(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            this.initOnLoad(fis);
            fis.close();
        }
        catch (Exception e) {
            this.errMsg = e.getMessage();
            logger.error("Load excel failed when from file,file=" + fileName, (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean isReady() {
        return this.workbook != null;
    }

    private CellFormater getColumnFormater(int sheetIndex, int colIndex) {
        List<CellFormater> ls = this.sheetCellFormat.get(new Integer(sheetIndex));
        if (colIndex >= ls.size()) {
            return null;
        }
        CellFormater cf = ls.get(colIndex);
        return cf;
    }

    private void createWorkBook(InputStream is) {
        if (this.isXlsxMode) {
            if (is == null) {
                this.workbook = new XSSFWorkbook();
            } else {
                try {
                    this.workbook = new XSSFWorkbook(is);
                }
                catch (Exception e) {
                    logger.error("\u8f7d\u5165Excel\u5931\u8d25", (Throwable)e);
                }
            }
        } else if (is == null) {
            this.workbook = new HSSFWorkbook();
        } else {
            try {
                this.workbook = new HSSFWorkbook(is);
            }
            catch (Exception e) {
                logger.error("\u8f7d\u5165Excel\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void initOnLoad(InputStream is) {
        this.createWorkBook(is);
        if (!this.isReady()) {
            return;
        }
        int cnt = this.workbook.getNumberOfSheets();
        logger.info("Load excel successfully,Sheet count=" + cnt);
        for (int i = 0; i < cnt; ++i) {
            Sheet sheet = this.workbook.getSheetAt(i);
            this.sheets.add(new SheetInfo(sheet));
            logger.info("--- Sheet:" + i + ") " + sheet.getSheetName() + ",rowCount=" + sheet.getLastRowNum());
        }
    }

    public SheetInfo getSheetInfo(int sheetIndex) {
        if (sheetIndex >= this.sheets.size()) {
            return null;
        }
        return this.sheets.get(sheetIndex);
    }

    public int getSheetCount() {
        return this.sheets.size();
    }

    public Workbook getWorkBook() {
        return this.workbook;
    }

    public String getSheetName(int sheetIndex) {
        if (sheetIndex >= this.sheets.size()) {
            return null;
        }
        SheetInfo sheetInf = this.getSheetInfo(sheetIndex);
        if (sheetInf == null) {
            return "";
        }
        return sheetInf.name;
    }

    public void createSheet(String sheetName) {
        if (this.workbook instanceof SXSSFWorkbook) {
            SXSSFSheet sheet = ((SXSSFWorkbook)this.workbook).createSheet(sheetName);
            sheet.trackAllColumnsForAutoSizing();
            this.sheets.add(new SheetInfo((Sheet)sheet));
            return;
        }
        this.sheets.add(new SheetInfo(this.workbook.createSheet(sheetName)));
    }

    public void setMemo(int sheetIndex, int cellCol, int cellRow, String text) {
        if (sheetIndex >= this.sheets.size()) {
            return;
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        sheetInf.sheet.createDrawingPatriarch();
        if (sheetInf.patr == null) {
            sheetInf.patr = this.sheets.get((int)sheetIndex).sheet.createDrawingPatriarch();
        }
        XSSFClientAnchor anchor = null;
        XSSFRichTextString richText = null;
        if (!this.isXlsxMode && !(sheetInf.sheet instanceof SXSSFSheet)) {
            anchor = new HSSFClientAnchor(0, 0, 0, 0, (short)cellCol, cellRow, (short)(cellCol + 2), cellRow + 4);
            richText = new HSSFRichTextString(text);
        } else {
            anchor = new XSSFClientAnchor(0, 0, 0, 0, (int)((short)cellCol), cellRow, (int)((short)(cellCol + 2)), cellRow + 4);
            richText = new XSSFRichTextString(text);
        }
        Comment comment = sheetInf.patr.createCellComment((ClientAnchor)anchor);
        comment.setString((RichTextString)richText);
        sheetInf.sheet.getRow(cellRow).getCell(cellCol).setCellComment(comment);
    }

    public void setMemo(int sheetIndex, String cellColName, int cellRow, String text) {
        int colIdx = ExcelFile.cellNameToIndex(cellColName);
        this.setMemo(sheetIndex, colIdx, cellRow, text);
    }

    public void setColumnsWidth(int sheetIndex, Integer ... colsWidth) {
        int colIdx = 0;
        for (Integer w : colsWidth) {
            if (w != null && w >= 0) {
                this.setColumnWidth(sheetIndex, colIdx, (int)w);
            }
            ++colIdx;
        }
    }

    public void setColumnWidth(int sheetIndex, String colName, int width) {
        int idx = ExcelFile.cellNameToIndex(colName);
        this.setColumnWidth(sheetIndex, idx, width);
    }

    public void setColumnWidth(int sheetIndex, int colIndex, int width) {
        SheetInfo inf = this.getSheetInfo(sheetIndex);
        if (inf == null) {
            return;
        }
        CellFormater cf = this.getColumnFormater(sheetIndex, colIndex);
        if (cf == null) {
            return;
        }
        try {
            width = 256 * width + 184;
            inf.sheet.setColumnWidth(colIndex, width);
            cf.cellWidth = width;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u8bbe\u7f6e\u5217\u5bbd\u5931\u8d25,sheet=" + sheetIndex + ",colIndex=" + colIndex, (Throwable)e);
        }
    }

    public void setGridShowState(int sheetIndex, boolean showFlag) {
        SheetInfo inf = this.getSheetInfo(sheetIndex);
        if (inf == null) {
            return;
        }
        inf.sheet.setDisplayGridlines(showFlag);
    }

    public void setCellBorder(int sheetIndex, String colName) {
        int idx = ExcelFile.cellNameToIndex(colName);
        this.setCellBorder(sheetIndex, idx, true, true, true, true);
    }

    public void setCellsBorderWithName(int sheetIndex, String ... colNames) {
        for (String n : colNames) {
            int idx = ExcelFile.cellNameToIndex(n);
            this.setCellBorder(sheetIndex, idx);
        }
    }

    public void setCellsBorder(int sheetIndex, String fromColName, String toColName) {
        int fromColIndex = ExcelFile.cellNameToIndex(fromColName);
        int toColIndex = ExcelFile.cellNameToIndex(toColName);
        this.setCellsBorder(sheetIndex, fromColIndex, toColIndex);
    }

    public void setCellsBorder(int sheetIndex, int fromColIndex, int toColIndex) {
        for (int i = fromColIndex; i <= toColIndex; ++i) {
            this.setCellBorder(sheetIndex, i);
        }
    }

    public void setCellsBorderWithIndex(int sheetIndex, int ... colIndexs) {
        for (int idx : colIndexs) {
            this.setCellBorder(sheetIndex, idx);
        }
    }

    public void setCellBorder(int sheetIndex, int colIndex) {
        this.setCellBorder(sheetIndex, colIndex, true, true, true, true);
    }

    public void setCellBorder(int sheetIndex, String colName, boolean left, boolean top, boolean right, boolean bottom) {
        int idx = ExcelFile.cellNameToIndex(colName);
        this.setCellBorder(sheetIndex, idx, true, true, true, true);
    }

    public void setCellBorder(int sheetIndex, int colIndex, boolean left, boolean top, boolean right, boolean bottom) {
        SheetInfo inf = this.getSheetInfo(sheetIndex);
        if (inf == null) {
            return;
        }
        CellFormater cf = this.getColumnFormater(sheetIndex, colIndex);
        if (cf == null) {
            return;
        }
        if (!cf.valid) {
            cf.style = this.workbook.createCellStyle();
            cf.valid = true;
        }
        cf.style.setVerticalAlignment((short)1);
        if (left) {
            cf.style.setBorderLeft((short)1);
        }
        if (right) {
            cf.style.setBorderRight((short)1);
        }
        if (top) {
            cf.style.setBorderTop((short)1);
        }
        if (bottom) {
            cf.style.setBorderBottom((short)1);
        }
    }

    public void setColumnFont(int sheetIndex, String colName, String fontName, int fontSize, int fontColor) {
        int idx = ExcelFile.cellNameToIndex(colName);
        this.setColumnFont(sheetIndex, idx, fontName, fontSize, fontColor);
    }

    public void setColumnFont(int sheetIndex, int colIndex, String fontName, int fontSize, int fontColor) {
        CellFormater cf = this.getColumnFormater(sheetIndex, colIndex);
        if (cf == null) {
            return;
        }
        if (!cf.valid) {
            cf.style = this.workbook.createCellStyle();
            cf.valid = true;
        }
        Font font = this.workbook.createFont();
        cf.style.setFont(font);
        if (fontSize > 0) {
            font.setFontHeightInPoints((short)fontSize);
        }
        font.setFontName(fontName);
        if (fontColor > 0) {
            font.setColor((short)fontColor);
        }
    }

    public void changeCellFont(int sheetIndex, int rowIndex, String colName, String fontName, int fontSize, int fontColor) {
        int idx = ExcelFile.cellNameToIndex(colName);
        this.changeCellFont(sheetIndex, rowIndex, idx, fontName, fontSize, fontColor);
    }

    public void changeCellFont(int sheetIndex, int rowIndex, int colIndex, String fontName, int fontSize, int fontColor) {
        SheetInfo inf = this.getSheetInfo(sheetIndex);
        if (inf == null) {
            return;
        }
        Row row = inf.sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            return;
        }
        CellStyle ocs = cell.getCellStyle();
        CellStyle cs = this.workbook.createCellStyle();
        cs.cloneStyleFrom(ocs);
        cell.setCellStyle(cs);
        Font font = this.workbook.createFont();
        cs.setFont(font);
        if (fontSize > 0) {
            font.setFontHeightInPoints((short)fontSize);
        }
        if (fontName != null && fontName.length() > 0) {
            font.setFontName(fontName);
        }
        if (fontColor > 0) {
            font.setColor((short)fontColor);
        }
    }

    public void freezePane(int sheetIndex, int freezeRowIndex, String freezeCellName) {
        int freezeCellIdx = ExcelFile.cellNameToIndex(freezeCellName);
        this.freezePane(sheetIndex, freezeRowIndex, freezeCellIdx);
    }

    public void freezePane(int sheetIndex, int freezeRowIndex, int freezeCellIndex) {
        SheetInfo sheetInf = this.getSheetInfo(sheetIndex);
        if (sheetInf == null) {
            return;
        }
        sheetInf.sheet.createFreezePane(freezeCellIndex, freezeRowIndex);
    }

    public void mergeCell(int sheetIndex, int fromRowIndex, String fromCellName, int toRowIndex, String toCellName) {
        int fromCellIdx = ExcelFile.cellNameToIndex(fromCellName);
        int toCellIdx = ExcelFile.cellNameToIndex(toCellName);
        this.mergeCell(sheetIndex, fromRowIndex, fromCellIdx, toRowIndex, toCellIdx);
    }

    public void mergeCell(int sheetIndex, int fromRowIndex, int fromCellIndex, int toRowIndex, int toCellIndex) {
        CellRangeAddress cra = new CellRangeAddress(fromRowIndex, toRowIndex, fromCellIndex, toCellIndex);
        SheetInfo sheetInf = this.getSheetInfo(sheetIndex);
        if (sheetInf == null) {
            return;
        }
        sheetInf.sheet.addMergedRegion(cra);
    }

    public void setCellsFormat(int sheetIndex, String[] formats) {
        if (this.workbook == null) {
            return;
        }
        if (sheetIndex > this.sheets.size()) {
            return;
        }
        Integer shIndex = new Integer(sheetIndex);
        List<CellFormater> formatLs = this.sheetCellFormat.get(shIndex);
        if (formatLs != null) {
            formatLs.clear();
        } else {
            formatLs = new ArrayList<CellFormater>();
        }
        if (formats == null) {
            return;
        }
        for (int i = 0; i < formats.length; ++i) {
            String s = formats[i];
            CellFormater cf = new CellFormater();
            formatLs.add(cf);
            if (s == null || s.length() == 0) {
                cf.valid = false;
                continue;
            }
            String[] inf = s.split(",");
            if (cf.style == null) {
                cf.style = this.workbook.createCellStyle();
            }
            if (inf.length > 0) {
                String[] tInf = inf[0].split(":");
                cf.type = tInf[0];
                cf.cellWidth = -1;
                if (tInf.length == 2 && tInf[1].trim().length() > 0) {
                    try {
                        int w = Integer.valueOf(tInf[1]);
                        cf.cellWidth = 256 * w + 184;
                    }
                    catch (Exception w) {
                        // empty catch block
                    }
                }
                if (cf.type.equals("D")) {
                    DataFormat df = this.workbook.createDataFormat();
                    cf.style.setDataFormat(df.getFormat("0.00"));
                }
                if (cf.type.equals("B")) {
                    DataFormat df = this.workbook.createDataFormat();
                    cf.style.setDataFormat(df.getFormat("0.000000"));
                } else if (cf.type.equals("S")) {
                    DataFormat df = this.workbook.createDataFormat();
                    cf.style.setDataFormat(df.getFormat("@"));
                }
            }
            if (inf.length > 1) {
                if (inf[1].equals("L")) {
                    cf.style.setAlignment((short)1);
                } else if (inf[1].equals("R")) {
                    cf.style.setAlignment((short)3);
                } else if (inf[1].equals("C")) {
                    cf.style.setAlignment((short)2);
                }
            }
            if (inf.length > 2 && inf[2].length() > 0) {
                int v = Integer.valueOf(inf[2]);
                cf.style.setFillPattern((short)1);
                cf.style.setFillForegroundColor((short)v);
            }
            if (inf.length > 3 && inf[3].length() > 0) {
                String[] fontInf = inf[3].split(":");
                int v = 0;
                if (fontInf.length > 1) {
                    v = Integer.valueOf(fontInf[1]);
                }
                Font font = this.workbook.createFont();
                if (v > 0) {
                    font.setFontHeightInPoints((short)v);
                }
                font.setFontName(fontInf[0]);
                cf.style.setFont(font);
            }
            cf.valid = true;
        }
        this.sheetCellFormat.put(shIndex, formatLs);
    }

    public void addRow(int sheetIndex, Object[] cellsValue, int rowHeight) {
        if (this.workbook == null) {
            return;
        }
        if (sheetIndex > this.sheets.size()) {
            return;
        }
        this.lastSheetIndex = sheetIndex;
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        Sheet sheet = sheetInf.sheet;
        List<CellFormater> formatLs = this.sheetCellFormat.get(new Integer(sheetIndex));
        int rowIdx = sheet.getLastRowNum() + 1;
        if (!sheetInf.hasRow) {
            sheetInf.hasRow = true;
            rowIdx = sheet.getLastRowNum();
        }
        Row row = sheet.createRow(rowIdx);
        row.setHeightInPoints((float)rowHeight);
        this.lastRowIndex = rowIdx;
        CellFormater cf = null;
        for (int i = 0; i < cellsValue.length; ++i) {
            Cell cell = row.createCell(i);
            this.lastCellIndex = i;
            Object cellValue = cellsValue[i];
            if (formatLs != null && i < formatLs.size()) {
                cf = formatLs.get(i);
            }
            try {
                if (cellValue == null) {
                    cellValue = "";
                    if (cf != null && cf.valid) {
                        if (cf.type.equals("N")) {
                            cellValue = new Integer(0);
                        } else if (cf.type.equals("D")) {
                            cellValue = BigDecimal.ZERO;
                        } else if (cf.type.equals("B")) {
                            cellValue = BigDecimal.ZERO;
                        }
                    }
                } else if (cellValue instanceof String && cf != null && cf.valid && ((String)cellValue).length() > 0) {
                    if (cf.type.equals("N")) {
                        BigDecimal parse = new BigDecimal((String)cellValue);
                        cellValue = new Integer(parse.intValue());
                    } else if (cf.type.equals("D")) {
                        cellValue = new BigDecimal((String)cellValue);
                    } else if (cf.type.equals("B")) {
                        cellValue = new BigDecimal((String)cellValue);
                    }
                }
            }
            catch (Exception e) {
                logger.error("---Excel\u6570\u636e\u8f6c\u6362\u5931\u8d25,\u5355\u5143\u683c[r=" + rowIdx + ",c=" + i + "(" + ExcelFile.indexToCellName(i) + ")],\u6570\u636e=[" + cellValue + "],\u8f6c\u7c7b\u578b=" + (cf == null ? "NULL" : cf.type));
                cellValue = "";
            }
            if (cellValue instanceof BigDecimal || cellValue instanceof Integer) {
                double dv = 0.0;
                dv = cellValue instanceof Integer ? ((Integer)cellValue).doubleValue() : ((BigDecimal)cellValue).doubleValue();
                cell.setCellType(0);
                cell.setCellValue(dv);
            } else {
                cell.setCellType(1);
                cell.setCellValue("" + cellValue);
            }
            if (cf != null && cf.cellWidth >= 0) {
                sheet.setColumnWidth(i, cf.cellWidth);
            } else {
                sheet.autoSizeColumn(i);
            }
            if (cf == null || !cf.valid) continue;
            cell.setCellStyle(cf.style);
        }
    }

    public List<String[]> readRows(int sheetIndex, int fromRowIndex, int toRowIndex) {
        if (this.workbook == null) {
            return null;
        }
        if (fromRowIndex < 0) {
            fromRowIndex = 0;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        SheetInfo sheetInf = this.getSheetInfo(sheetIndex);
        if (sheetInf == null) {
            return list;
        }
        int rowCnt = sheetInf.sheet.getLastRowNum();
        logger.info("\u8bfb\u53d6Excel\u6570\u636e,\u8d77\u59cb\u884c=" + fromRowIndex + ",\u7ed3\u675f\u884c=" + toRowIndex + ",\u603b\u884c\u6570=" + rowCnt);
        if (toRowIndex < 0 || toRowIndex > rowCnt) {
            toRowIndex = rowCnt;
        }
        for (int i = fromRowIndex; i <= toRowIndex; ++i) {
            String[] data = this.readRow(sheetIndex, i);
            if (data == null) continue;
            list.add(data);
        }
        return list;
    }

    public String[] readRow(int sheetIndex, int rowIndex) {
        if (this.workbook == null) {
            return null;
        }
        if (sheetIndex >= this.sheets.size()) {
            return new String[0];
        }
        SheetInfo sheetInf = this.sheets.get(sheetIndex);
        Row row = sheetInf.sheet.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        this.lastSheetIndex = sheetIndex;
        this.lastRowIndex = rowIndex;
        int cellCnt = row.getLastCellNum();
        logger.debug("Read excel sheet [" + sheetInf.name + "] row,row=" + rowIndex + " cellCnt=" + cellCnt);
        String[] fields = new String[cellCnt];
        for (int i = 0; i < cellCnt; ++i) {
            Cell cell = row.getCell(i);
            this.lastCellIndex = i;
            String v = "";
            if (cell != null) {
                try {
                    v = this.getCellValue(cell);
                }
                catch (Exception e) {
                    this.errMsg = "sheet=" + sheetInf.name + ",row=" + rowIndex + ",cell=" + i;
                    logger.error("----\u89e3\u6790Excel\u6570\u636e\u5931\u8d25," + this.errMsg, (Throwable)e);
                }
            }
            fields[i] = v;
        }
        return fields;
    }

    private String getCellValue(Cell cell) {
        String v = "";
        if (cell == null) {
            return v;
        }
        if (cell.getCellType() == 4) {
            v = String.valueOf(cell.getBooleanCellValue());
        } else if (cell.getCellType() == 0) {
            v = String.valueOf(cell.getNumericCellValue());
        } else if (cell.getCellType() == 1) {
            v = String.valueOf(cell.getStringCellValue());
        } else {
            cell.setCellType(1);
            v = String.valueOf(cell.getStringCellValue());
        }
        return v;
    }

    public void setArrayValue(Object[] ary, String value, int ... aryIdxs) {
        if (ary == null) {
            return;
        }
        if (aryIdxs == null || aryIdxs.length == 0) {
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = value;
            }
        } else {
            for (int i : aryIdxs) {
                ary[i] = value;
            }
        }
    }

    public void setArrayValueByNames(Object[] ary, String value, String ... cellNames) {
        if (ary == null) {
            return;
        }
        if (cellNames == null || cellNames.length == 0) {
            for (int i = 0; i < ary.length; ++i) {
                ary[i] = value;
            }
            return;
        }
        for (int i = 0; i < cellNames.length; ++i) {
            String n = cellNames[i].toUpperCase();
            int idx = ExcelFile.cellNameToIndex(n);
            ary[idx] = value;
        }
    }

    public static String indexToCellName(int aryIndex) {
        if (aryIndex < 0) {
            return "";
        }
        int dv = aryIndex / 26;
        int mv = aryIndex % 26;
        if (dv == 0) {
            return String.valueOf((char)(mv + 65));
        }
        return String.valueOf((char)(mv + 65)) + ExcelFile.indexToCellName(dv);
    }

    public static int cellNameToIndex(String name) {
        int idx = 0;
        name = name.toUpperCase();
        int len = name.length();
        for (int j = 0; j < len; ++j) {
            idx = idx + (name.charAt(len - j - 1) - 65) + j * 26;
        }
        return idx;
    }

    public void close() {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveAsFile(String fileName) {
        if (this.workbook == null) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            this.workbook.write((OutputStream)fos);
            this.workbook.close();
            fos.close();
        }
        catch (Exception e) {
            logger.error("Save excel to file failed,file=" + fileName, (Throwable)e);
            e.printStackTrace();
        }
    }

    public void saveAsOutStream(OutputStream out) {
        if (this.workbook == null) {
            return;
        }
        try {
            this.workbook.write(out);
            this.workbook.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String saveAsHexString() {
        if (this.workbook == null) {
            return "";
        }
        String s = "";
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            this.workbook.write((OutputStream)bao);
            this.workbook.close();
            byte[] buf = bao.toByteArray();
            bao.close();
            logger.info("Excel save to HEX string,excel size=" + buf.length);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < buf.length; ++i) {
                int v = buf[i] & 0xFF;
                if (v < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(v));
            }
            s = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static void main(String[] args) {
        ExcelFile excel = ExcelFile.ofStreamed();
        excel.createSheet("\u6d4b\u8bd5\u6587\u4ef6");
        int sheetIdx = 0;
        Object[] columnTitles = new String[]{"\u5e8f\u53f7", "\u59d3\u548c\u540d\u5b57", "", "\u6570\u91cf", "\u91d1\u989d", "\u5907\u6ce8"};
        Object[] cellFormat = new String[columnTitles.length];
        excel.setArrayValueByNames(cellFormat, ",,51,\u9ed1\u4f53:12", "A", "B", "C", "D", "E", "F");
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setCellsBorder(sheetIdx, "A", "F");
        excel.addRow(sheetIdx, columnTitles, 14);
        excel.mergeCell(sheetIdx, 0, "B", 0, "C");
        cellFormat = new String[columnTitles.length];
        excel.setArrayValueByNames(cellFormat, ",,,\u9ed1\u4f53:12", "A", "B", "C", "F");
        excel.setArrayValueByNames(cellFormat, ":10,R,,\u9ed1\u4f53:12", "B", "C");
        excel.setArrayValueByNames(cellFormat, "N,R,,\u9ed1\u4f53:12", "D");
        excel.setArrayValueByNames(cellFormat, "D,R,,\u9ed1\u4f53:12", "E");
        excel.setCellsFormat(sheetIdx, (String[])cellFormat);
        excel.setCellsBorder(sheetIdx, "A", "F");
        excel.setColumnWidth(sheetIdx, "F", 23);
        Object[] columnDatas = new String[]{"1\u53f7", "\u5f20", "\u98de\u626c", "99", "1000.21", "\u5217\u5bbd\u81ea\u52a8\u6269\u5c55"};
        excel.addRow(sheetIdx, columnDatas, 14);
        columnDatas = new String[]{"2\u53f7", "\u5e38", "\u4f55\u4e3a", "60", "9000.21", "\u6307\u5b9a\u5bbd\u5ea6"};
        excel.addRow(sheetIdx, columnDatas, 14);
        excel.changeCellFont(sheetIdx, 2, "D", "\u5b8b\u4f53", 20, 17);
        excel.setMemo(sheetIdx, "B", 1, "\u59d3\u5355\u72ec\u4e00\u5217");
        excel.freezePane(sheetIdx, 1, "B");
        excel.saveAsFile("D:/temp/testfile.xlsx");
        excel.close();
        System.out.println("ok");
    }

    class SheetInfo {
        public Sheet sheet;
        public Drawing patr;
        public boolean hasRow;
        public String name;

        public SheetInfo(Sheet sheet) {
            this.sheet = sheet;
            this.hasRow = false;
            this.name = sheet.getSheetName();
        }
    }

    class CellFormater {
        public boolean valid = false;
        public String type = "";
        public int cellWidth = -1;
        public CellStyle style = null;

        CellFormater() {
        }
    }
}

