/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.pay.common;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;

public class PDFShowPageFooterEvent
extends PdfPageEventHelper {
    private PdfTemplate total;
    private Rectangle rectangle;
    private Font zh;
    private Font pt;

    public PDFShowPageFooterEvent(Rectangle rectangle, Font zh, Font pt) {
        this.rectangle = rectangle;
        this.zh = zh;
        this.pt = pt;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(10.0f, 10.0f);
    }

    public void onStartPage(PdfWriter writer, Document document) {
        super.onStartPage(writer, document);
        try {
            Phrase pagination = new Phrase();
            pagination.add((Object)new Chunk(String.format("%s   /", writer.getPageNumber()), this.pt));
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)pagination, (float)(this.rectangle.getWidth() / 2.0f), (float)10.0f, (float)0.0f);
            Image image = Image.getInstance((PdfTemplate)this.total);
            image.setAbsolutePosition(this.rectangle.getWidth() / 2.0f + 17.0f, 10.0f);
            document.add((Element)image);
        }
        catch (DocumentException e) {
            throw new ExceptionConverter((Exception)((Object)e));
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        ColumnText.showTextAligned((PdfContentByte)this.total, (int)0, (Phrase)new Phrase(new Chunk(String.valueOf(writer.getPageNumber() - 1), this.pt)), (float)0.0f, (float)0.0f, (float)0.0f);
    }
}

