/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.exception;

import com.cgd.common.exception.ErrorMessageProvider;

public class BusException
extends RuntimeException {
    private static ErrorMessageProvider errorMessageProvider;
    private static final long serialVersionUID = 2216260154324846575L;
    public static final String UNKNOWN_MESSAGE = "\u7cfb\u7edf\u7e41\u5fd9\u8bf7\u7a0d\u540e\u518d\u8bd5";
    public static final String ILLEGAL_MESSAGE = "\u975e\u6cd5\u64cd\u4f5c";
    public static final String ID_NULL = "\u4f20\u5165\u7684id\u4e3a\u7a7a";
    public static final String SENMESSAGE_ERROR = "\u77ed\u4fe1\u53d1\u9001\u5931\u8d25";
    public static final String AWSTIME_MESSAGE = "AWS\u8fde\u63a5\u5f02\u5e38";
    public static final String AWSID_MESSAGE = "AWSID\u4e0d\u5b58\u5728";
    private String errorCode;
    private Object[] args;
    private String message;

    public BusException() {
    }

    public BusException(String message) {
        this.message = message;
    }

    public BusException(String message, String ... args) {
        this.args = args;
        this.message = message;
    }

    public BusException(String message, Throwable throwable) {
        super(message, throwable);
        this.message = message;
    }

    public BusException(Throwable throwable) {
        super(throwable);
    }

    @Override
    public String getMessage() {
        String errorText = this.message;
        if (errorText == null || "".equals(errorText)) {
            Throwable cause = super.getCause();
            return cause != null ? cause.getMessage() : this.message;
        }
        if (this.args != null && this.args.length > 0) {
            errorText = String.format(errorText, this.args);
        }
        if (errorMessageProvider != null) {
            String message = errorMessageProvider.getErrorMessage(errorText);
            return message;
        }
        return errorText;
    }

    public static void setErrorMessageProvider(ErrorMessageProvider errorMessageProvider) {
        BusException.errorMessageProvider = errorMessageProvider;
    }
}

