/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.cache;

import com.cgd.common.exception.BusException;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.common.loader.perms.PermissionLoader;
import com.cgd.common.utils.SpringApplicationContext;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class PermissionCacheServiceImpl
implements PermissionCacheService {
    private static final int cacheTimeoutMinute = 1;
    private static final String PERMISSION_CACHE_PREFIX = "PERMISSION_CACHE$$";
    private static final String DATA_PERMIS_CACHE_PREFIX = "DATA_PERMIS_CACHE$$";
    private static PermissionLoader permissionLoader = null;

    public boolean hasAuthority(String authCode, Long userId) {
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return false;
        }
        PermissionBean perms = new PermissionBean();
        perms.setAuthority(authCode);
        String key = PERMISSION_CACHE_PREFIX + userId;
        List list = PermissionCacheServiceImpl.getPermissionLoader().loadUserPermissions(userId);
        if (list != null) {
            return list.contains(perms);
        }
        return false;
    }

    public DataPermissionBean getDataPermission(PermissionCacheService.ResrcCode resrcCode, Long userId) {
        if (userId == null) {
            throw new BusException("\u7f3a\u5c11\u7528\u6237ID");
        }
        if (resrcCode == null) {
            return PermissionCacheServiceImpl.selfDataPermission(resrcCode, userId);
        }
        String key = DATA_PERMIS_CACHE_PREFIX + userId;
        List dataPermsList = PermissionCacheServiceImpl.getPermissionLoader().loadDataPermission(userId);
        if (dataPermsList != null && !dataPermsList.isEmpty()) {
            for (DataPermissionBean dataPerms : dataPermsList) {
                if (!resrcCode.getResrcCode().equals(dataPerms.getResrcCode())) continue;
                return dataPerms;
            }
        }
        return PermissionCacheServiceImpl.selfDataPermission(resrcCode, userId);
    }

    private static DataPermissionBean selfDataPermission(PermissionCacheService.ResrcCode resrcCode, Long userId) {
        DataPermissionBean dataPerms = new DataPermissionBean(resrcCode.getResrcCode());
        dataPerms.getAuthorisedUserIds().add(userId);
        return dataPerms;
    }

    private static PermissionLoader getPermissionLoader() {
        if (permissionLoader == null) {
            permissionLoader = SpringApplicationContext.getBean(PermissionLoader.class);
        }
        return permissionLoader;
    }
}

