/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.page;

import org.apache.ibatis.session.RowBounds;

public class Pagination
extends RowBounds {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private int totalRecord;
    private int pageSize = 10;
    private int totalPage;
    private int currentPage = 1;

    public Pagination() {
    }

    public Pagination(int currentPage) {
        super(Pagination.offsetCurrent(currentPage) * 10, 10);
        if (currentPage > 1) {
            this.currentPage = currentPage;
        }
    }

    public Pagination(int currentPage, int pageSize) {
        super(Pagination.offsetCurrent(currentPage) * pageSize, pageSize);
        if (currentPage > 1) {
            this.currentPage = currentPage;
        }
        this.pageSize = pageSize;
    }

    protected static int offsetCurrent(int currentPage) {
        if (currentPage > 0) {
            return currentPage - 1;
        }
        return 0;
    }

    public boolean hasPrevious() {
        return this.currentPage > 1;
    }

    public boolean hasNext() {
        return this.currentPage < this.totalPage;
    }

    public int getTotalRecord() {
        return this.totalRecord;
    }

    public void setTotalRecord(int totalRecord) {
        this.totalRecord = totalRecord;
        if (this.pageSize == 0) {
            return;
        }
        this.totalPage = this.totalRecord / this.pageSize;
        if (this.totalRecord % this.pageSize != 0) {
            ++this.totalPage;
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentOffset() {
        return (this.currentPage - 1) * this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public String toString() {
        return "Pagination { totalRecord=" + this.totalRecord + " ,pageSize=" + this.pageSize + " ,totalPage=" + this.totalPage + " ,currentPage=" + this.currentPage + " }";
    }
}

