/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.common.page;

import com.cgd.common.page.Dialect;
import com.cgd.common.page.MysqlDialect;
import com.cgd.common.page.OracleDialect;
import com.cgd.common.page.Pagination;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class PaginationInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        Object target = invocation.getTarget();
        if (target instanceof StatementHandler) {
            StatementHandler statementHandler = (StatementHandler)target;
            MetaObject metaStatementHandler = SystemMetaObject.forObject((Object)statementHandler);
            RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
            if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
                return invocation.proceed();
            }
            Configuration configuration = (Configuration)metaStatementHandler.getValue("delegate.configuration");
            Dialect.Type databaseType = null;
            try {
                databaseType = Dialect.Type.valueOf(configuration.getVariables().getProperty("dialect").toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (databaseType == null) {
                throw new RuntimeException("the value of the dialect property in configuration.xml is not defined : " + configuration.getVariables().getProperty("dialect"));
            }
            Dialect dialect = null;
            switch (databaseType) {
                case ORACLE: {
                    dialect = new OracleDialect();
                    break;
                }
                case MYSQL: {
                    dialect = new MysqlDialect();
                    break;
                }
                default: {
                    throw new RuntimeException("the value of the dialect property in configuration.xml is not defined : " + configuration.getVariables().getProperty("dialect"));
                }
            }
            BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
            String originalSql = boundSql.getSql();
            MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
            Connection connection = (Connection)invocation.getArgs()[0];
            Pagination page = this.count(originalSql, connection, mappedStatement, boundSql, (Pagination)rowBounds);
            metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
            metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
            metaStatementHandler.setValue("delegate.boundSql.sql", (Object)dialect.getPageSQL(originalSql, page.getCurrentOffset(), page.getPageSize()));
        }
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pagination count(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, Pagination page) {
        String sqlUse = sql;
        int orderByIndex = sql.toUpperCase().lastIndexOf("ORDER BY");
        if (orderByIndex > -1) {
            sqlUse = sql.substring(0, orderByIndex);
        }
        StringBuffer countSql = new StringBuffer("SELECT COUNT(1) FROM (");
        countSql.append(sqlUse).append(") AS TOTAL");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(countSql.toString());
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql.toString(), boundSql.getParameterMappings(), boundSql.getParameterObject());
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, boundSql.getParameterObject(), countBS);
            parameterHandler.setParameters(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            int totalRecord = 0;
            if (resultSet.next()) {
                totalRecord = resultSet.getInt(1);
            }
            page.setTotalRecord(totalRecord);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return page;
    }

    public Object plugin(Object target) {
        if (target instanceof StatementHandler) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties arg0) {
    }
}

