/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.distrbt.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.auth.distrbt.po.AuthDistribute;
import com.cgd.manage.auth.distrbt.service.AuthDistributeService;
import com.cgd.manage.auth.group.dao.AuthGroupMapper;
import com.cgd.manage.auth.group.dao.AuthGroupUserMapper;
import com.cgd.manage.auth.group.po.AuthGroup;
import com.cgd.manage.auth.group.po.AuthGroupUser;
import com.cgd.manage.auth.role.dao.AuthRoleMapper;
import com.cgd.manage.auth.role.po.AuthRole;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.orgstn.service.OrgOrganisationService;
import com.cgd.manage.org.user.dao.OrgUserMapper;
import com.cgd.manage.org.user.po.OrgUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthDistributeServiceImpl
implements AuthDistributeService {
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private AuthRoleMapper authRoleMapper;
    @Autowired
    private AuthGroupMapper authGroupMapper;
    @Autowired
    private OrgUserMapper orgUserMapper;
    @Autowired
    private OrgOrganisationMapper orgOrganisationMapper;
    @Autowired
    private OrgOrganisationService orgOrganisationService;
    @Autowired
    private AuthGroupUserMapper authGroupUserMapper;

    public PageBo<Map<String, Object>> getOrgsByRole(Long roleId, boolean flag, Long uid, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Object> dataList = new ArrayList();
        if (flag) {
            dataList = this.authDistributeMapper.selectOrgsByRole(roleId, page);
        } else {
            OrgUser orgUser = this.orgUserMapper.selectByID(uid);
            OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgUser.getAdmOrgid());
            dataList = this.authDistributeMapper.selectOrgsByRoleAdm(roleId, orgOrganisation.getAutoCode(), page);
        }
        for (Map map : dataList) {
            map.put("orgTitle", this.orgOrganisationService.queryOrgFullName((String)map.get("orgAutoCode")));
        }
        page.setRecords(dataList);
        return page;
    }

    public PageBo<Map<String, Object>> getAllOrgsExpRole(Long parentId, Long exceptRole, Long uid, String queryStr, PageBo<Map<String, Object>> pageBo) {
        List<Map<String, Object>> exceptDataList = this.authDistributeMapper.selectOrgsByRole(exceptRole, new Page<Map<String, Object>>(1, Integer.MAX_VALUE));
        ArrayList<Long> exceptOrgs = null;
        if (exceptDataList != null && !exceptDataList.isEmpty()) {
            exceptOrgs = new ArrayList<Long>();
            for (Map<String, Object> map : exceptDataList) {
                exceptOrgs.add((Long)map.get("orgId"));
            }
        }
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        OrgUser orgUser = this.orgUserMapper.selectByID(uid);
        List<Object> dataList = new ArrayList();
        dataList = parentId.equals(orgUser.getAdmOrgid()) ? this.authDistributeMapper.getAllOrgsExpOrgs(parentId, exceptOrgs, orgUser.getAdmOrgid(), queryStr, page) : this.authDistributeMapper.getAllOrgsExpOrgs(parentId, exceptOrgs, null, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<Map<String, Object>> getRolesByOrg(String orgAutoCode, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Map<String, Object>> dataList = this.authDistributeMapper.selectRolesByOrg(orgAutoCode, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAllRolesExpOrg(String exceptOrgAutoCode, String queryStr, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAllRolesExpOrg(exceptOrgAutoCode, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<Map<String, Object>> getUsersByRole(Long roleId, boolean falg, Long uid, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Object> dataList = new ArrayList();
        if (falg) {
            dataList = this.authDistributeMapper.selectUsersByRole(roleId, page);
        } else {
            OrgUser orgUser = this.orgUserMapper.selectByID(uid);
            OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgUser.getAdmOrgid());
            dataList = this.authDistributeMapper.selectUsersByRoleAdm(roleId, orgOrganisation.getAutoCode(), page);
        }
        if (dataList != null && !dataList.isEmpty()) {
            for (Map map : dataList) {
                String code = (String)map.get("orgAutoCode");
                String orgFullName = this.orgOrganisationService.queryOrgFullName(code);
                map.put("orgFullName", orgFullName);
            }
        }
        page.setRecords(dataList);
        return page;
    }

    public PageBo<Map<String, Object>> getAllUsersExpRole(String orgAutoCode, Long exceptRole, String queryStr, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Map<String, Object>> dataList = this.authDistributeMapper.selectAllUsersExpRole(orgAutoCode, exceptRole, queryStr, page);
        if (dataList != null && !dataList.isEmpty()) {
            for (Map<String, Object> data : dataList) {
                String code = (String)data.get("orgAutoCode");
                String orgFullName = this.orgOrganisationService.queryOrgFullName(code);
                data.put("orgFullName", orgFullName);
            }
        }
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getRolesByUser(Long userId, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectRolesByUser(userId, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAllRolesExpUser(Long exceptUser, String queryStr, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAllRolesExpUser(exceptUser, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAdmRolesExpUser(Long exceptUser, Long admId, String queryStr, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAdmRolesExpUser(exceptUser, admId, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthGroup> getGroupsByRole(Long roleId, PageBo<AuthGroup> pageBo) {
        Page<AuthGroup> page = new Page<AuthGroup>(pageBo);
        List<AuthGroup> dataList = this.authDistributeMapper.selectGroupsByRole(roleId, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthGroup> getAllGroupsExpRole(Long exceptRole, String queryStr, PageBo<AuthGroup> pageBo) {
        Page<AuthGroup> page = new Page<AuthGroup>(pageBo);
        List<AuthGroup> dataList = this.authDistributeMapper.selectAllGroupsExpRole(exceptRole, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getRolesByGroup(Long groupId, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectRolesByGroup(groupId, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAllRolesExpGroup(Long exceptGroup, String queryStr, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAllRolesExpGroup(exceptGroup, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    @Transactional
    public void addDistribute(AuthDistribute authDistribute) {
        AuthRole role = this.authRoleMapper.selectByPrimaryKey(authDistribute.getRoleId());
        if (role == null) {
            throw new BusException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        if (1 == authDistribute.getDisFlag()) {
            OrgUser user = this.orgUserMapper.selectByID(authDistribute.getUserId());
            if (user == null) {
                throw new BusException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
        } else if (2 == authDistribute.getDisFlag()) {
            AuthGroup group = this.authGroupMapper.selectByPrimaryKey(authDistribute.getGroupId());
            if (group == null) {
                throw new BusException("\u7528\u6237\u7ec4\u4e0d\u5b58\u5728");
            }
        } else if (3 == authDistribute.getDisFlag()) {
            OrgOrganisation org = this.orgOrganisationMapper.selectByAutoCode(authDistribute.getOrgAutoCode());
            if (org == null) {
                throw new BusException("\u7ec4\u7ec7\u673a\u6784\u4e0d\u5b58\u5728");
            }
        } else {
            throw new BusException("\u4e0d\u652f\u6301\u7684\u6388\u6743\u65b9\u5f0f");
        }
        authDistribute.setCreateTm(new Date());
        this.authDistributeMapper.insert(authDistribute);
    }

    @Transactional
    public void saveRoleOrgs(Long roleId, List<String> orgAutoCodes, boolean orgExtend) {
        if (roleId == null || orgAutoCodes == null || orgAutoCodes.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < orgAutoCodes.size(); ++i) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleId);
            authDistribute.setUserId(null);
            authDistribute.setGroupId(null);
            authDistribute.setOrgAutoCode(orgAutoCodes.get(i));
            authDistribute.setOrgExtend(Integer.valueOf(orgExtend ? 1 : 0));
            authDistribute.setDisFlag(Integer.valueOf(3));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRoleOrgs(Long roleId, List<String> orgAutoCodes) {
        if (roleId == null || orgAutoCodes == null || orgAutoCodes.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRoleOrgs(roleId, orgAutoCodes);
    }

    @Transactional
    public void saveRolesOrg(List<Long> roleIds, String orgAutoCode, boolean orgExtend) {
        if (orgAutoCode == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < roleIds.size(); ++i) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleIds.get(i));
            authDistribute.setUserId(null);
            authDistribute.setGroupId(null);
            authDistribute.setOrgAutoCode(orgAutoCode);
            authDistribute.setOrgExtend(Integer.valueOf(orgExtend ? 1 : 0));
            authDistribute.setDisFlag(Integer.valueOf(3));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRolesOrg(List<Long> roleIds, String orgAutoCode) {
        if (orgAutoCode == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRolesOrg(roleIds, orgAutoCode);
    }

    @Transactional
    public void saveRoleUsers(Long roleId, List<Long> userIds) {
        if (roleId == null || userIds == null || userIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < userIds.size(); ++i) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleId);
            authDistribute.setUserId(userIds.get(i));
            authDistribute.setGroupId(null);
            authDistribute.setOrgAutoCode(null);
            authDistribute.setDisFlag(Integer.valueOf(1));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRoleUsers(Long roleId, List<Long> userIds) {
        if (roleId == null || userIds == null || userIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRoleUsers(roleId, userIds);
    }

    @Transactional
    public void saveRolesUser(List<Long> roleIds, Long userId) {
        if (userId == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < roleIds.size(); ++i) {
            int num = this.authDistributeMapper.select(roleIds.get(i), userId);
            if (num > 0) continue;
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleIds.get(i));
            authDistribute.setUserId(userId);
            authDistribute.setGroupId(null);
            authDistribute.setOrgAutoCode(null);
            authDistribute.setDisFlag(Integer.valueOf(1));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRolesUser(List<Long> roleIds, Long userId) {
        if (userId == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRolesUser(roleIds, userId);
    }

    @Transactional
    public void saveRoleGroups(Long roleId, List<Long> groupIds) {
        if (roleId == null || groupIds == null || groupIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < groupIds.size(); ++i) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleId);
            authDistribute.setUserId(null);
            authDistribute.setGroupId(groupIds.get(i));
            authDistribute.setOrgAutoCode(null);
            authDistribute.setDisFlag(Integer.valueOf(2));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRoleGroups(Long roleId, List<Long> groupIds) {
        if (roleId == null || groupIds == null || groupIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRoleGroups(roleId, groupIds);
    }

    @Transactional
    public void saveRolesGroup(List<Long> roleIds, Long groupId) {
        if (groupId == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < roleIds.size(); ++i) {
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(roleIds.get(i));
            authDistribute.setUserId(null);
            authDistribute.setGroupId(groupId);
            authDistribute.setOrgAutoCode(null);
            authDistribute.setDisFlag(Integer.valueOf(2));
            this.addDistribute(authDistribute);
        }
    }

    @Transactional
    public void deleteRolesGroup(List<Long> roleIds, Long groupId) {
        if (groupId == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7528\u6237\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authDistributeMapper.deleteRolesGroup(roleIds, groupId);
    }

    public List<Map<String, String>> getAllRolesByUser(Long userId, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        long orgL = new Date().getTime();
        long orgLs = new Date().getTime();
        System.out.println("org:" + (orgLs - orgL));
        long roleL = new Date().getTime();
        List<AuthRole> dataList = this.authDistributeMapper.selectRolesByUserMap(userId, page);
        long roleLs = new Date().getTime();
        System.out.println("role:" + (roleLs - roleL));
        long group = new Date().getTime();
        List<AuthGroupUser> authGroups = this.authGroupUserMapper.selectByUserId(userId);
        long groups = new Date().getTime();
        System.out.println("group:" + (groups - group));
        ArrayList<Object> dataListGroups = new ArrayList<Object>();
        List<Object> dataListGroup = new ArrayList();
        long groupL = new Date().getTime();
        for (AuthGroupUser authGroupUser : authGroups) {
            dataListGroup = this.authDistributeMapper.selectRolesByGroupMap(authGroupUser.getGroupId(), page);
            if (dataListGroup == null || dataListGroup.size() <= 0) continue;
            dataListGroups.addAll(dataListGroup);
        }
        long groupLs = new Date().getTime();
        System.out.println("groupL:" + (groupLs - groupL));
        OrgUser orgUser = this.orgUserMapper.selectByID(userId);
        OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgUser.getOrgId());
        long orgsL = new Date().getTime();
        List<Object> dataListOrg = new ArrayList();
        if (orgOrganisation != null) {
            dataListOrg = this.authDistributeMapper.selectRolesByOrgMap(orgOrganisation.getAutoCode(), page);
        }
        long orgsLs = new Date().getTime();
        System.out.println("orgsL:" + (orgsLs - orgsL));
        int size = Math.max(Math.max(dataList.size(), dataListGroups.size()), dataListOrg.size());
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        long forl = new Date().getTime();
        for (int i = 0; i < size; ++i) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("userGranted", i < dataList.size() ? dataList.get(i).getRolename() : null);
            result.put("orgGranted", i < dataListOrg.size() ? ((AuthRole)dataListOrg.get(i)).getRolename() : null);
            result.put("groupGranted", i < dataListGroups.size() ? ((AuthRole)dataListGroups.get(i)).getRolename() : null);
            resultList.add(result);
        }
        long forls = new Date().getTime();
        System.out.println("forls" + (forls - forl));
        return resultList;
    }

    public PageBo<AuthRole> getAllRolesExpOrg(String orgAutoCode, Long userId, String serachContent, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAllRolesExpOrgByAdmId(orgAutoCode, userId, serachContent, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAllRolesExpGroup(Long userId, Long groupId, String serachContent, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authDistributeMapper.selectAllRolesExpGroupByAdmId(userId, groupId, serachContent, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthGroup> getGroupsByRole(Long userId, Long roleId, PageBo<AuthGroup> pageBo) {
        Page<AuthGroup> page = new Page<AuthGroup>(pageBo);
        List<AuthGroup> dataList = this.authDistributeMapper.selectGroupsByRoleByAdmId(userId, roleId, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthGroup> getAllGroupsExpRole(Long userId, Long roleId, String queryStr, PageBo<AuthGroup> pageBo) {
        Page<AuthGroup> page = new Page<AuthGroup>(pageBo);
        List<AuthGroup> dataList = this.authDistributeMapper.selectAllGroupsExpRoleByAdmId(userId, roleId, queryStr, page);
        page.setRecords(dataList);
        return page;
    }
}

