/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.group.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.auth.group.dao.AuthGroupMapper;
import com.cgd.manage.auth.group.dao.AuthGroupUserMapper;
import com.cgd.manage.auth.group.po.AuthGroup;
import com.cgd.manage.auth.group.po.AuthGroupUser;
import com.cgd.manage.auth.group.service.AuthGroupService;
import com.cgd.manage.org.orgstn.service.OrgOrganisationService;
import com.cgd.manage.org.user.dao.OrgUserMapper;
import com.cgd.manage.org.user.po.OrgUser;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthGroupServiceImpl
implements AuthGroupService {
    @Autowired
    private AuthGroupMapper authGroupMapper;
    @Autowired
    private AuthGroupUserMapper authGroupUserMapper;
    @Autowired
    private OrgUserMapper orgUserMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private OrgOrganisationService organisationService;

    @Transactional(readOnly=true)
    public PageBo<AuthGroup> queryGroups(PageBo<AuthGroup> pageBo, String queryLike) {
        Page<AuthGroup> page = null;
        if (pageBo != null) {
            page = new Page<AuthGroup>(pageBo);
        }
        List<AuthGroup> dataList = this.authGroupMapper.selectGroups(queryLike, page);
        for (AuthGroup authgroup : dataList) {
            OrgUser orguser = this.orgUserMapper.selectByID(authgroup.getCreateUid());
            String name = orguser.getName();
            authgroup.setCreateName(name);
        }
        page.setRecords(dataList);
        return page;
    }

    @Transactional(readOnly=true)
    public AuthGroup getGroupById(Long groupId) {
        return this.authGroupMapper.selectByPrimaryKey(groupId);
    }

    @Transactional
    public void deleteGroup(Long ... groupIds) {
        if (groupIds == null || groupIds.length == 0) {
            throw new BusException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u7528\u6237\u7ec4");
        }
        for (Long groupId : groupIds) {
            this.authGroupUserMapper.deleteGroupUsers(groupId, null);
            this.authDistributeMapper.deleteAllRoleGroup(groupId);
            this.authDistributeMapper.deleteAllRoleGroupData(groupId);
        }
        this.authGroupMapper.deleteByPrimaryKeys(groupIds);
    }

    @Transactional
    public void updateGroup(AuthGroup group) {
        AuthGroup grp = this.authGroupMapper.selectByPrimaryKey(group.getAutoId());
        grp.setGroupname(group.getGroupname());
        grp.setDescrip(group.getDescrip());
        grp.setUpdateUid(group.getUpdateUid());
        grp.setUpdateTm(group.getUpdateTm());
        int count = this.authGroupMapper.selectcountByid(group.getAutoId(), group.getGroupname());
        if (count > 0) {
            throw new BusException("\u4fee\u6539\u7528\u6237\u7ec4\u4fe1\u606f\u5931\u8d25");
        }
        this.authGroupMapper.updateByPrimaryKey(grp);
    }

    @Transactional
    public void addGroup(AuthGroup group) {
        int count = this.authGroupMapper.selectcount(group.getGroupname());
        if (count > 0) {
            throw new BusException("\u65b0\u589e\u7528\u6237\u7ec4\u5931\u8d25");
        }
        this.authGroupMapper.insert(group);
    }

    public PageBo<Map<String, Object>> getAllUsersExpGroup(Long expGroupId, String orgAutoCode, String queryStr, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Map<String, Object>> dataList = this.authGroupUserMapper.selectAllUsersExpGroup(expGroupId, orgAutoCode, queryStr, page);
        if (dataList != null && !dataList.isEmpty()) {
            for (Map<String, Object> data : dataList) {
                String code = (String)data.get("orgAutoCode");
                String orgFullName = this.organisationService.queryOrgFullName(code);
                data.put("orgFullName", orgFullName);
            }
        }
        page.setRecords(dataList);
        return page;
    }

    public PageBo<Map<String, Object>> getUsersByGroup(Long groupId, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Map<String, Object>> dataList = this.authGroupUserMapper.selectUsersByGroup(groupId, page);
        if (dataList != null && !dataList.isEmpty()) {
            for (Map<String, Object> data : dataList) {
                String code = (String)data.get("orgAutoCode");
                String orgFullName = this.organisationService.queryOrgFullName(code);
                data.put("orgFullName", orgFullName);
            }
        }
        page.setRecords(dataList);
        return page;
    }

    @Transactional
    public void saveGroupUsers(Long groupId, List<Long> userIds, Long currentUid) {
        if (groupId == null || userIds == null || userIds.isEmpty()) {
            throw new BusException("\u4fdd\u5b58\u7528\u6237\u7ec4\u6210\u5458\u5931\u8d25");
        }
        for (int i = 0; i < userIds.size(); ++i) {
            AuthGroupUser gu = new AuthGroupUser();
            gu.setGroupId(groupId);
            gu.setUserId(userIds.get(i));
            gu.setCreateTm(new Date());
            gu.setCreateUid(currentUid);
            this.saveAuthGroupUser(gu);
        }
    }

    @Transactional
    public void saveAuthGroupUser(AuthGroupUser groupUser) {
        AuthGroup group = this.authGroupMapper.selectByPrimaryKey(groupUser.getGroupId());
        if (group == null) {
            throw new BusException("\u7528\u6237\u7ec4\u4e3a\u7a7a");
        }
        OrgUser user = this.orgUserMapper.selectByID(groupUser.getUserId());
        if (user == null) {
            throw new BusException("\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.authGroupUserMapper.insert(groupUser);
    }

    public void deleteGroupUsers(Long groupId, List<Long> userIds) {
        if (groupId == null || userIds == null || userIds.isEmpty()) {
            throw new BusException("\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        this.authGroupUserMapper.deleteGroupUsers(groupId, userIds);
    }

    public PageBo<AuthGroup> queryGroups(PageBo<AuthGroup> pageBo, String queryStr, Long userId) {
        Page<AuthGroup> page = null;
        if (pageBo != null) {
            page = new Page<AuthGroup>(pageBo);
        }
        List<AuthGroup> dataList = this.authGroupMapper.selectGroupsByAdmId(queryStr, page, userId);
        for (AuthGroup authgroup : dataList) {
            OrgUser orguser = this.orgUserMapper.selectByID(authgroup.getCreateUid());
            authgroup.setCreateName(orguser.getName());
        }
        page.setRecords(dataList);
        return page;
    }
}

