/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.perms.service.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.manage.auth.perms.dao.AuthMenuMapper;
import com.cgd.manage.auth.perms.po.AuthMenu;
import com.cgd.manage.auth.perms.service.AuthMenuService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthMenuServiceImpl
implements AuthMenuService {
    @Autowired
    private AuthMenuMapper authMenuMapper;
    @Autowired
    private OrgOrganisationMapper orgOrganisationMapper;

    public List<AuthMenu> getAllMenusCodeSorted() {
        return this.authMenuMapper.selectAllMenusCodeSorted();
    }

    public AuthMenu selectUpByAutoId(Long autoId) {
        return this.authMenuMapper.selectUpByAutoId(autoId);
    }

    public int updateByAutoId(Map<String, Object> condition) throws BusinessException {
        return this.authMenuMapper.updateByAutoId(condition);
    }

    public AuthMenu selectByAutoId(Long autoId) {
        return this.authMenuMapper.selectByAutoId(autoId);
    }

    @Transactional
    public void updateByID(AuthMenu authMenu) {
        authMenu.setUpdateTm(new Date());
        this.authMenuMapper.updateByID(authMenu);
    }

    @Transactional(readOnly=true)
    public List<AuthMenu> selectTree() {
        return this.authMenuMapper.selectTree();
    }

    @Transactional
    public void upMenu(Long autoId) {
        AuthMenu currentMenu = this.selectByAutoId(autoId);
        AuthMenu upMenu = this.authMenuMapper.selectUpMenuByID(currentMenu.getParentId(), currentMenu.getOrderId());
        AuthMenu menuDept = new AuthMenu();
        menuDept.setAutoId(autoId);
        menuDept.setOrderId(upMenu.getOrderId());
        this.authMenuMapper.updateByID(menuDept);
        menuDept = new AuthMenu();
        menuDept.setAutoId(upMenu.getAutoId());
        menuDept.setOrderId(currentMenu.getOrderId());
        this.authMenuMapper.updateByID(menuDept);
    }

    @Transactional
    public void downMenu(Long autoId) {
        AuthMenu currentMenu = this.selectByAutoId(autoId);
        AuthMenu downMenu = this.authMenuMapper.selectDownMenuByID(currentMenu.getParentId(), currentMenu.getOrderId());
        AuthMenu menuDept = new AuthMenu();
        menuDept.setAutoId(autoId);
        menuDept.setOrderId(downMenu.getOrderId());
        this.authMenuMapper.updateByID(menuDept);
        menuDept = new AuthMenu();
        menuDept.setAutoId(downMenu.getAutoId());
        menuDept.setOrderId(currentMenu.getOrderId());
        this.authMenuMapper.updateByID(menuDept);
    }

    public List<AuthMenu> getUserMenuPers(Long userId) {
        OrgOrganisation orgOrganisation;
        List<AuthMenu> authByUserGroup;
        ArrayList<AuthMenu> authMenus = new ArrayList<AuthMenu>();
        List<AuthMenu> authByUserOnly = this.authMenuMapper.selectPersByUserId(userId);
        if (authByUserOnly != null && !authByUserOnly.isEmpty()) {
            authMenus.addAll(authByUserOnly);
        }
        if ((authByUserGroup = this.authMenuMapper.selectPersByUserGroup(userId)) != null && !authByUserGroup.isEmpty()) {
            AuthMenuServiceImpl.addMenu(authMenus, authByUserGroup);
        }
        if ((orgOrganisation = this.orgOrganisationMapper.selectByUserId(userId)) != null) {
            List<AuthMenu> authByOrgUp;
            String orgAutoCode = orgOrganisation.getAutoCode();
            List<AuthMenu> authByOrgOnly = this.authMenuMapper.selectPersByOrgOnly(orgAutoCode);
            if (authByOrgOnly != null && !authByOrgOnly.isEmpty()) {
                AuthMenuServiceImpl.addMenu(authMenus, authByOrgOnly);
            }
            if ((authByOrgUp = this.authMenuMapper.selectPersByOrgUp(orgAutoCode)) != null && !authByOrgUp.isEmpty()) {
                AuthMenuServiceImpl.addMenu(authMenus, authByOrgUp);
            }
        }
        return authMenus;
    }

    private static List<AuthMenu> addMenu(List<AuthMenu> hasAuthList, List<AuthMenu> newAuthList) {
        ArrayList<Long> tmpHasAuth = new ArrayList<Long>();
        if (hasAuthList != null) {
            for (AuthMenu am : hasAuthList) {
                tmpHasAuth.add(am.getAutoId());
            }
        }
        if (hasAuthList != null && newAuthList != null) {
            for (AuthMenu na : newAuthList) {
                if (tmpHasAuth.contains(na.getAutoId())) continue;
                hasAuthList.add(na);
            }
        }
        return hasAuthList;
    }
}

