/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.perms.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.perms.dao.AuthPermissionMapper;
import com.cgd.manage.auth.perms.po.AuthPermission;
import com.cgd.manage.auth.perms.service.AuthPermissionService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.user.po.OrgUser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthPermissionServiceImpl
implements AuthPermissionService {
    @Autowired
    private AuthPermissionMapper authPermissionMapper;
    @Autowired
    private OrgOrganisationMapper orgOrganisationMapper;

    public AuthPermission selectByPrimaryKey(String authority) {
        return this.authPermissionMapper.selectByPrimaryKey(authority);
    }

    public List<AuthPermission> getAllPermissions() {
        return this.authPermissionMapper.selectAllPermissions();
    }

    @Transactional(readOnly=true)
    public PageBo<AuthPermission> selectListByMenuId(Map<String, Object> condition, PageBo<AuthPermission> pageBo) {
        Page<AuthPermission> page = new Page<AuthPermission>(pageBo);
        page.setRecords(this.authPermissionMapper.selectListByMenuId(condition, page));
        return page;
    }

    public List<AuthPermission> getUserPermissions(Long userId) {
        OrgOrganisation orgOrganisation;
        List<AuthPermission> authByUserGroup;
        ArrayList<AuthPermission> authPermissions = new ArrayList<AuthPermission>();
        List<AuthPermission> authByUserOnly = this.authPermissionMapper.selectPersByUserId(userId);
        if (authByUserOnly != null && !authByUserOnly.isEmpty()) {
            authPermissions.addAll(authByUserOnly);
        }
        if ((authByUserGroup = this.authPermissionMapper.selectPersByUserGroup(userId)) != null && !authByUserGroup.isEmpty()) {
            authPermissions.addAll(authByUserGroup);
        }
        if ((orgOrganisation = this.orgOrganisationMapper.selectByUserId(userId)) != null) {
            List<AuthPermission> authByOrgUp;
            String orgAutoCode = orgOrganisation.getAutoCode();
            List<AuthPermission> authByOrgOnly = this.authPermissionMapper.selectPersByOrgOnly(orgAutoCode);
            if (authByOrgOnly != null && !authByOrgOnly.isEmpty()) {
                authPermissions.addAll(authByOrgOnly);
            }
            if ((authByOrgUp = this.authPermissionMapper.selectPersByOrgUp(orgAutoCode)) != null && !authByOrgUp.isEmpty()) {
                authPermissions.addAll(authByOrgUp);
            }
        }
        return authPermissions;
    }

    public List<OrgUser> getUsersByPermis(String permission) {
        List<OrgUser> list;
        List<OrgUser> usersWithOrgOnly;
        ArrayList<OrgUser> users = new ArrayList<OrgUser>();
        List<OrgUser> usersWithSelf = this.authPermissionMapper.selectUsersByPermisWithSelf(permission);
        HashSet<Long> userIds = new HashSet<Long>();
        if (usersWithSelf != null && !usersWithSelf.isEmpty()) {
            for (OrgUser orgUser : usersWithSelf) {
                if (userIds.contains(orgUser.getUserId())) continue;
                users.add(orgUser);
                userIds.add(orgUser.getUserId());
            }
        }
        if ((usersWithOrgOnly = this.authPermissionMapper.selectUsersByPermisWithOrgOnly(permission)) != null && !usersWithOrgOnly.isEmpty()) {
            for (OrgUser user : usersWithOrgOnly) {
                if (userIds.contains(user.getUserId())) continue;
                users.add(user);
                userIds.add(user.getUserId());
            }
        }
        if ((list = this.authPermissionMapper.selectUsersByPermisWithOrgUp(permission)) != null && !list.isEmpty()) {
            for (OrgUser user : list) {
                if (userIds.contains(user.getUserId())) continue;
                users.add(user);
                userIds.add(user.getUserId());
            }
        }
        return users;
    }
}

