/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.perms.service.impl;

import com.cgd.common.bo.BaseReq;
import com.cgd.manage.auth.perms.po.AuthMenu;
import com.cgd.manage.auth.perms.service.AuthMenuService;
import com.cgd.manage.intfce.auth.bo.MenuRspBo;
import com.cgd.manage.intfce.auth.service.MenuBusinService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MenuBusinServiceImpl
implements MenuBusinService {
    @Autowired
    private AuthMenuService authMenuService;

    public List<MenuRspBo> queryUserMenuPers(BaseReq userIdReq) {
        List userMenuPers = this.authMenuService.getUserMenuPers(userIdReq.getUserId());
        List<MenuRspBo> menuInfos = new ArrayList<MenuRspBo>();
        for (AuthMenu authMenu : userMenuPers) {
            MenuRspBo menuInfo = new MenuRspBo();
            menuInfo.setAutoId(authMenu.getAutoId());
            menuInfo.setParentId(authMenu.getParentId());
            menuInfo.setDeep(authMenu.getDeep());
            menuInfo.setOrderId(authMenu.getOrderId());
            menuInfo.setMenuName(authMenu.getMenuName());
            menuInfo.setMenuCode(authMenu.getMenuCode());
            menuInfo.setMenuIcon(authMenu.getMenuIcon());
            menuInfo.setMenuCss(authMenu.getMenuCss());
            menuInfo.setMenuUrl(authMenu.getMenuUrl());
            menuInfo.setUpdateUid(authMenu.getUpdateUid());
            menuInfo.setUpdateTm(authMenu.getUpdateTm());
            menuInfo.setDisFlag(authMenu.getDisFlag());
            if (Locale.ENGLISH.equals(userIdReq.getLocale())) {
                menuInfo.setMenuName(authMenu.getMenuNameEn());
            }
            menuInfos.add(menuInfo);
        }
        menuInfos = this.ascSortByDeepAndOrderId(menuInfos);
        return menuInfos;
    }

    private List<MenuRspBo> ascSortByDeepAndOrderId(List<MenuRspBo> menuInfos) {
        if (menuInfos == null) {
            return menuInfos;
        }
        if (menuInfos.size() == 1) {
            return menuInfos;
        }
        for (int i = 0; i < menuInfos.size(); ++i) {
            for (int j = 0; j < menuInfos.size() - 1 - i; ++j) {
                MenuRspBo temp;
                if (menuInfos.get(j).getDeep() > menuInfos.get(j + 1).getDeep()) {
                    temp = menuInfos.get(j);
                    menuInfos.set(j, menuInfos.get(j + 1));
                    menuInfos.set(j + 1, temp);
                    continue;
                }
                if (menuInfos.get(j).getDeep().intValue() != menuInfos.get(j + 1).getDeep().intValue() || menuInfos.get(j).getOrderId() <= menuInfos.get(j + 1).getOrderId()) continue;
                temp = menuInfos.get(j);
                menuInfos.set(j, menuInfos.get(j + 1));
                menuInfos.set(j + 1, temp);
            }
        }
        return menuInfos;
    }
}

