/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.perms.service.impl;

import com.cgd.common.bo.BaseReq;
import com.cgd.common.exception.BusException;
import com.cgd.manage.auth.perms.po.AuthPermission;
import com.cgd.manage.auth.perms.service.AuthPermissionService;
import com.cgd.manage.intfce.auth.bo.PermissionRspBo;
import com.cgd.manage.intfce.auth.bo.QueryUsersByPermisReqBo;
import com.cgd.manage.intfce.auth.service.PermissionBusinService;
import com.cgd.manage.intfce.user.bo.UserRspBo;
import com.cgd.manage.org.user.po.OrgUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionBusinServiceImpl
implements PermissionBusinService {
    @Autowired
    private AuthPermissionService authPermissionService;

    public List<PermissionRspBo> queryUserPermissions(BaseReq userIdReq) {
        List userPermissions = this.authPermissionService.getUserPermissions(userIdReq.getUserId());
        ArrayList<PermissionRspBo> permsList = new ArrayList<PermissionRspBo>();
        for (AuthPermission perms : userPermissions) {
            PermissionRspBo rsp = new PermissionRspBo();
            rsp.setAuthority(perms.getAuthority());
            rsp.setDescrip(perms.getDescrip());
            rsp.setMenuId(perms.getMenuId());
            rsp.setTitle(perms.getTitle());
            permsList.add(rsp);
        }
        return permsList;
    }

    public List<UserRspBo> queryUsersByPermis(QueryUsersByPermisReqBo reqBo) {
        if (reqBo == null || reqBo.getPermission() == null) {
            throw new BusException("\u975e\u6cd5\u64cd\u4f5c");
        }
        List users = this.authPermissionService.getUsersByPermis(reqBo.getPermission());
        ArrayList<UserRspBo> userRspList = new ArrayList<UserRspBo>();
        if (users != null && !users.isEmpty()) {
            for (OrgUser user : users) {
                UserRspBo userRspBo = new UserRspBo();
                userRspBo.setDeptName(null);
                userRspBo.setEmpId(user.getEmpId());
                userRspBo.setJobName(null);
                userRspBo.setLoginname(user.getLoginname());
                userRspBo.setName(user.getName());
                userRspBo.setOrgId(user.getOrgId());
                userRspBo.setUserId(user.getUserId());
                userRspList.add(userRspBo);
            }
        }
        return userRspList;
    }
}

