/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.perms.service.impl;

import com.cgd.common.exception.BusException;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionBean;
import com.cgd.common.loader.perms.PermissionLoader;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.auth.group.dao.AuthGroupUserMapper;
import com.cgd.manage.auth.perms.po.AuthPermission;
import com.cgd.manage.auth.perms.service.AuthPermissionService;
import com.cgd.manage.auth.role.dao.AuthRoleDataPermsMapper;
import com.cgd.manage.auth.role.po.AuthRole;
import com.cgd.manage.auth.role.po.AuthRoleDataPerms;
import com.cgd.manage.auth.role.service.AuthRoleDataPermissionService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.user.po.OrgUser;
import com.cgd.manage.org.user.service.OrgUserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionLoaderServiceImpl
implements PermissionLoader {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private AuthRoleDataPermsMapper roleDataPermsMapper;
    @Autowired
    private OrgUserService orgUserService;
    @Autowired
    private OrgOrganisationMapper organisationMapper;
    @Autowired
    private AuthGroupUserMapper authGroupUserMapper;

    public List<PermissionBean> loadUserPermissions(Long userId) {
        List tmpList = this.authPermissionService.getUserPermissions(userId);
        ArrayList<PermissionBean> list = null;
        if (tmpList != null && tmpList.size() > 0) {
            list = new ArrayList<PermissionBean>();
            for (AuthPermission tmp : tmpList) {
                PermissionBean rs = new PermissionBean();
                BeanUtils.copyProperties((Object)tmp, (Object)rs);
                list.add(rs);
            }
        }
        return list;
    }

    public List<DataPermissionBean> loadDataPermission(Long userId) {
        List<AuthRoleDataPerms> roleDataPermisList;
        OrgOrganisation org;
        if (userId == null) {
            throw new BusException("\u975e\u6cd5\u64cd\u4f5c");
        }
        OrgUser orgUser = this.orgUserService.selectByID(userId);
        if (orgUser == null) {
            throw new BusException("\u975e\u6cd5\u64cd\u4f5c");
        }
        HashSet<Long> roleIds = new HashSet<Long>();
        Page<AuthRole> page = new Page<AuthRole>(1, Integer.MAX_VALUE);
        List<AuthRole> userRoles = this.authDistributeMapper.selectRolesByUser(userId, page);
        if (userRoles != null && !userRoles.isEmpty()) {
            for (AuthRole role : userRoles) {
                roleIds.add(role.getAutoId());
            }
        }
        if ((org = this.organisationMapper.selectByID(orgUser.getOrgId())) != null) {
            Page<Map<String, Object>> pageMap = new Page<Map<String, Object>>(1, Integer.MAX_VALUE);
            List<Map<String, Object>> orgRoles = this.authDistributeMapper.selectRolesByOrg(org.getAutoCode(), pageMap);
            if (orgRoles != null && !orgRoles.isEmpty()) {
                for (Map<String, Object> role : orgRoles) {
                    roleIds.add((Long)role.get("roleId"));
                }
            }
        }
        HashMap<String, DataPermissionBean> dataPermisMaps = new HashMap<String, DataPermissionBean>();
        if (!roleIds.isEmpty() && (roleDataPermisList = this.roleDataPermsMapper.selectByRolesAndResrcCode(roleIds.toArray(new Long[0]), null)) != null && !roleDataPermisList.isEmpty()) {
            for (AuthRoleDataPerms dp : roleDataPermisList) {
                String orgAutoCode;
                List<Map<Object, Object>> orgTrees;
                OrgOrganisation orgInfo;
                String resrcCode = dp.getResrcCode();
                DataPermissionBean dataPermisBean = (DataPermissionBean)dataPermisMaps.get(resrcCode);
                if (dataPermisBean == null) {
                    dataPermisBean = new DataPermissionBean(resrcCode);
                    dataPermisBean.getAuthorisedUserIds().add(userId);
                    dataPermisMaps.put(resrcCode, dataPermisBean);
                }
                if (AuthRoleDataPermissionService.DataScope.Comp.getScope().equals(dp.getScope())) {
                    orgInfo = this.organisationMapper.selectByID(orgUser.getCompId());
                    if (orgInfo == null || orgInfo.getAutoCode() == null || (orgTrees = this.organisationMapper.selectTreeByOrgCode(orgInfo.getAutoCode())) == null || orgTrees.isEmpty()) continue;
                    for (Map<Object, Object> otherOrg : orgTrees) {
                        dataPermisBean.getAuthorisedOrgIds().add((Long)otherOrg.get("id"));
                    }
                    continue;
                }
                if (AuthRoleDataPermissionService.DataScope.Enterprise.getScope().equals(dp.getScope())) {
                    String[] split;
                    String autoCode;
                    List<Map<Object, Object>> orgTrees2;
                    orgInfo = this.organisationMapper.selectByID(orgUser.getCompId());
                    if (orgInfo != null && orgInfo.getAutoCode() != null && (orgTrees2 = this.organisationMapper.selectTreeDeptByOrgCode(autoCode = orgInfo.getAutoCode(), (split = autoCode.split("-")).length)) != null && !orgTrees2.isEmpty()) {
                        for (Map<Object, Object> otherOrg : orgTrees2) {
                            dataPermisBean.getAuthorisedOrgIds().add((Long)otherOrg.get("id"));
                        }
                    }
                    dataPermisBean.getAuthorisedOrgIds().add(orgUser.getCompId());
                    continue;
                }
                if (AuthRoleDataPermissionService.DataScope.Dept.getScope().equals(dp.getScope())) {
                    dataPermisBean.getAuthorisedOrgIds().add(orgUser.getOrgId());
                    continue;
                }
                if (AuthRoleDataPermissionService.DataScope.OthOrg.getScope().equals(dp.getScope())) {
                    orgAutoCode = dp.getOrgAutoCode();
                    OrgOrganisation otherOrg = this.organisationMapper.selectByAutoCode(orgAutoCode);
                    if (otherOrg == null) continue;
                    dataPermisBean.getAuthorisedOrgIds().add(otherOrg.getAutoId());
                    continue;
                }
                if (!AuthRoleDataPermissionService.DataScope.OthOrgTree.getScope().equals(dp.getScope()) || (orgTrees = this.organisationMapper.selectTreeByOrgCode(orgAutoCode = dp.getOrgAutoCode())) == null || orgTrees.isEmpty()) continue;
                for (Map<Object, Object> otherOrg : orgTrees) {
                    dataPermisBean.getAuthorisedOrgIds().add((Long)otherOrg.get("id"));
                }
            }
        }
        return new ArrayList<DataPermissionBean>(dataPermisMaps.values());
    }
}

