/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.role.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.role.dao.AuthRoleAdmMapper;
import com.cgd.manage.auth.role.dao.AuthRoleMapper;
import com.cgd.manage.auth.role.po.AuthRole;
import com.cgd.manage.auth.role.po.AuthRoleAdm;
import com.cgd.manage.auth.role.service.AuthRoleAdmService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthRoleAdmServiceImpl
implements AuthRoleAdmService {
    @Autowired
    private AuthRoleAdmMapper authRoleAdmMapper;
    @Autowired
    private AuthRoleMapper authRoleMapper;

    public PageBo<AuthRole> getRolesByUser(Long userId, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authRoleAdmMapper.selectRolesByUser(userId, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> getAllRolesExpUser(Long userId, String queryStr, PageBo<AuthRole> pageBo) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authRoleAdmMapper.selectAllRolesExpUser(userId, queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    @Transactional
    public void saveAuthRoleAdm(List<Long> roleIds, String userId) {
        if (userId == null || roleIds == null || roleIds.isEmpty()) {
            throw new BusException("\u89d2\u8272\u6216\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < roleIds.size(); ++i) {
            AuthRoleAdm authRole = new AuthRoleAdm();
            authRole.setRoleId(roleIds.get(i));
            authRole.setAdmUserid(Long.valueOf(Long.parseLong(userId)));
            AuthRole role = this.authRoleMapper.selectByPrimaryKey(roleIds.get(i));
            if (role == null) {
                throw new BusException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            this.authRoleAdmMapper.insert(authRole);
        }
    }

    @Transactional
    public void deleteRolesUser(Long[] roleIds) {
        this.authRoleAdmMapper.deleteByPrimaryKeys(roleIds);
    }
}

