/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.role.service.impl;

import com.cgd.common.exception.BusException;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.manage.auth.role.dao.AuthRoleDataPermsMapper;
import com.cgd.manage.auth.role.po.AuthRoleDataPerms;
import com.cgd.manage.auth.role.service.AuthRoleDataPermissionService;
import com.cgd.manage.org.orgstn.service.OrgOrganisationService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthRoleDataPermissionServiceImpl
implements AuthRoleDataPermissionService {
    @Autowired
    private AuthRoleDataPermsMapper dataPermsMapper;
    @Autowired
    private OrgOrganisationService organisationService;

    @Transactional(readOnly=true)
    public List<Map<String, Object>> queryRoleDataPermissionsInMap(Long roleId) {
        List<Map<String, Object>> dataPermisList = this.dataPermsMapper.selectByRoleInMap(roleId);
        if (dataPermisList != null && !dataPermisList.isEmpty()) {
            for (Map<String, Object> dataPermis : dataPermisList) {
                String resrcCode = (String)dataPermis.get("resrc_code");
                dataPermis.put("resrcCode", PermissionCacheService.ResrcCode.getEnum((String)resrcCode));
                String scope = (String)dataPermis.get("scope");
                dataPermis.put("dataScope", AuthRoleDataPermissionService.DataScope.getEnum((String)scope));
                String orgAutoCode = (String)dataPermis.get("org_auto_code");
                if (orgAutoCode == null) continue;
                String orgFullName = this.organisationService.queryOrgFullName(orgAutoCode);
                dataPermis.put("orgFullName", orgFullName);
            }
        }
        return dataPermisList;
    }

    @Transactional
    public void addRoleDataPermission(AuthRoleDataPerms dataPermis) {
        if (dataPermis == null) {
            throw new BusException("\u975e\u6cd5\u64cd\u4f5c");
        }
        this.dataPermsMapper.insert(dataPermis);
    }

    @Transactional
    public void delRoleDataPermission(Long ... dataPermsIds) {
        if (dataPermsIds == null || dataPermsIds.length == 0) {
            throw new BusException("\u975e\u6cd5\u64cd\u4f5c");
        }
        for (Long id : dataPermsIds) {
            this.dataPermsMapper.deleteByPrimaryKey(id);
        }
    }
}

