/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.role.service.impl;

import com.cgd.manage.auth.perms.po.AuthMenu;
import com.cgd.manage.auth.perms.po.AuthPermission;
import com.cgd.manage.auth.role.dao.AuthRolePermsMapper;
import com.cgd.manage.auth.role.po.AuthRolePerms;
import com.cgd.manage.auth.role.service.AuthRolePermsService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthRolePermsServiceImpl
implements AuthRolePermsService {
    @Autowired
    private AuthRolePermsMapper authRolePermsMapper;

    public List<AuthMenu> getMenusByRole(Long roleId) {
        return this.authRolePermsMapper.selectMenusByRole(roleId);
    }

    public List<AuthPermission> getPermsByRole(Long roleId) {
        return this.authRolePermsMapper.selectPermsByRole(roleId);
    }

    @Transactional
    public void saveConfig(Long roleId, List<Long> menuIds, List<String> permsIds) {
        AuthRolePerms re;
        this.authRolePermsMapper.deleteRolePerms(roleId, null);
        this.authRolePermsMapper.deleteRoleMenu(roleId, null);
        ArrayList<AuthRolePerms> res = new ArrayList<AuthRolePerms>();
        if (menuIds != null) {
            for (Long menuId : menuIds) {
                re = new AuthRolePerms();
                re.setMenuId(menuId);
                re.setRoleId(roleId);
                re.setRelFlag(Integer.valueOf(1));
                res.add(re);
            }
        }
        if (permsIds != null) {
            for (String permId : permsIds) {
                re = new AuthRolePerms();
                re.setPermAuthority(permId);
                re.setRoleId(roleId);
                re.setRelFlag(Integer.valueOf(2));
                res.add(re);
            }
        }
        if (!res.isEmpty()) {
            this.authRolePermsMapper.insertMulit(res);
        }
    }
}

