/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.auth.role.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.auth.role.dao.AuthRoleAdmMapper;
import com.cgd.manage.auth.role.dao.AuthRoleMapper;
import com.cgd.manage.auth.role.po.AuthRole;
import com.cgd.manage.auth.role.service.AuthRoleService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthRoleServiceImpl
implements AuthRoleService {
    @Autowired
    private AuthRoleMapper authRoleMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private AuthRoleAdmMapper authRoleAdmMapper;

    public PageBo<AuthRole> queryRoles(PageBo<AuthRole> pageBo, String queryLike) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authRoleMapper.queryRoles(queryLike, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<AuthRole> queryRoles(PageBo<AuthRole> pageBo, String queryLike, Long userId) {
        Page<AuthRole> page = new Page<AuthRole>(pageBo);
        List<AuthRole> dataList = this.authRoleMapper.queryRolesById(queryLike, userId, page);
        page.setRecords(dataList);
        return page;
    }

    @Transactional
    public void addRole(AuthRole role) {
        int count = this.authRoleMapper.selectcount(role.getRolename());
        if (count > 0) {
            throw new BusException("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        role.setSysFlag(Integer.valueOf(0));
        this.authRoleMapper.insert(role);
    }

    @Transactional
    public void updateRole(AuthRole role) {
        AuthRole r = this.authRoleMapper.selectByPrimaryKey(role.getAutoId());
        r.setRolename(role.getRolename());
        r.setDescrip(role.getDescrip());
        r.setUpdateUid(role.getUpdateUid());
        r.setUpdateTm(role.getUpdateTm());
        int count = this.authRoleMapper.selectcountByid(role.getRolename(), role.getAutoId());
        if (count > 0) {
            throw new BusException("\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.authRoleMapper.updateByPrimaryKey(r);
    }

    @Transactional
    public void deleteRole(Long ... roleIds) {
        if (roleIds == null || roleIds.length == 0) {
            throw new BusException("\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < roleIds.length; ++i) {
            if (this.authDistributeMapper.queryCounts(roleIds[i]) > 0) {
                throw new BusException("\u89d2\u8272\u5df2\u88ab\u4f7f\u7528\u3002\u4e0d\u80fd\u5220\u9664");
            }
            if (this.authRoleAdmMapper.queryCounts(roleIds[i]) > 0) {
                throw new BusException("\u89d2\u8272\u5df2\u88ab\u4f7f\u7528\u3002\u4e0d\u80fd\u5220\u9664");
            }
            this.authRoleMapper.deleteByPrimaryKeys(roleIds);
        }
    }

    public AuthRole getRoleById(Long roleId) {
        return this.authRoleMapper.selectByPrimaryKey(roleId);
    }
}

