/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.dic.dict.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.manage.dic.dict.dao.DicDictionaryMapper;
import com.cgd.manage.dic.dict.po.DicDictionary;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DicDictionaryServiceImpl
implements DicDictionaryService {
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;
    @Autowired
    private CacheService cacheService;

    public PageBo<DicDictionary> getdict(PageBo<DicDictionary> pageBo, String queryStr) {
        Page<DicDictionary> page = new Page<DicDictionary>(pageBo);
        List<DicDictionary> dataList = this.dicDictionaryMapper.selectdict(queryStr, page);
        page.setRecords(dataList);
        return page;
    }

    public PageBo<DicDictionary> getdicty(PageBo<DicDictionary> pageBo, String queryStr, String pcode) {
        Page<DicDictionary> page = new Page<DicDictionary>(pageBo);
        List<DicDictionary> dictList = this.dicDictionaryMapper.selectdicty(queryStr, page, pcode);
        page.setRecords(dictList);
        return page;
    }

    public void adddict(DicDictionary dict) {
        int count = this.dicDictionaryMapper.selectcount(dict.getCode(), dict.getpCode());
        if (count > 0) {
            throw new BusException("\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.dicDictionaryMapper.insertdicty(dict);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dict.getpCode()})) {
            this.cacheService.delete(dict.getpCode());
        }
    }

    @Transactional
    public int updatedict(DicDictionary dict) {
        DicDictionary dictionary = this.dicDictionaryMapper.selectdictionaryByCodeAndCode(dict.getCode(), dict.getpCode());
        dictionary.setTitle(dict.getTitle());
        dictionary.setOrderId(dict.getOrderId());
        dictionary.setUpdateUid(dict.getUpdateUid());
        dictionary.setUpdateTm(dict.getUpdateTm());
        int num = this.dicDictionaryMapper.updatedicty(dictionary);
        if (num > 0 && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dictionary.getpCode()})) {
            this.cacheService.delete(dictionary.getpCode());
        }
        return num;
    }

    public DicDictionary selectdict(String code) {
        DicDictionary dictionary = this.dicDictionaryMapper.selectdictionary(code);
        return dictionary;
    }

    public DicDictionary selectdictionaryByCodeAndCode(String code, String pcode) {
        DicDictionary dictionary = this.dicDictionaryMapper.selectdictionaryByCodeAndCode(code, pcode);
        return dictionary;
    }

    @Transactional
    public int deletedict(String code) {
        DicDictionary dicDictionary = this.dicDictionaryMapper.selectByPrimaryKey(code);
        int num = this.dicDictionaryMapper.updateDisFlag(code);
        this.dicDictionaryMapper.selectByPrimaryKey(code);
        if (num > 0 && dicDictionary != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dicDictionary.getpCode()})) {
            this.cacheService.delete(dicDictionary.getpCode());
        }
        return num;
    }

    @Transactional
    public List<DicDictionary> selectDictValByCode(String code) {
        return this.dicDictionaryMapper.selectDictValByCode(code);
    }

    public Map<String, String> getValueByCode(String pCode) {
        List<DicDictionary> list = this.dicDictionaryMapper.selectByPCode(pCode);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DicDictionary dicDictionary : list) {
            map.put(dicDictionary.getCode(), dicDictionary.getTitle());
        }
        return map;
    }
}

