/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.org.orgstn.service.impl;

import com.cgd.common.bo.PageBo;
import com.cgd.common.cache.service.CacheService;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.common.utils.TransJsonAndMapUtil;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.orgstn.service.OrgOrganisationService;
import com.cgd.manage.org.user.dao.OrgUserMapper;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgOrganisationServiceImpl
implements OrgOrganisationService {
    @Autowired
    private OrgOrganisationMapper orgOrganisationMapper;
    @Autowired
    private OrgUserMapper orgUserMapper;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private CacheService cacheService;
    private static final String TREEPREFIX = "tree";

    @Transactional(readOnly=true)
    public OrgOrganisation selectByID(Long autoId) {
        String extJson;
        Map<String, Object> parseObject;
        OrgOrganisation organisation = this.orgOrganisationMapper.selectByID(autoId);
        if (organisation != null && (parseObject = TransJsonAndMapUtil.jsonToMap(extJson = organisation.getExtJson())) != null) {
            organisation.setTel((String)parseObject.get("tel"));
            organisation.setEmail((String)parseObject.get("email"));
            organisation.setFax((String)parseObject.get("fax"));
            organisation.setAddress((String)parseObject.get("address"));
            organisation.setRemark((String)parseObject.get("remark"));
            organisation.setLinkman((String)parseObject.get("linkman"));
        }
        return organisation;
    }

    @Transactional(readOnly=true)
    public List<Map<Object, Object>> selectTree() {
        return this.orgOrganisationMapper.selectTree();
    }

    @Transactional(readOnly=true)
    public List<Map<Object, Object>> selectTree(Long orgId) {
        Object o;
        OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgId);
        String orgCode = "";
        if (orgOrganisation != null) {
            orgCode = orgOrganisation.getAutoCode();
        }
        if (orgCode == "") {
            orgCode = "null";
        }
        if ((o = this.cacheService.get(TREEPREFIX + orgCode)) != null) {
            System.out.println("redis\u7f13\u5b58\u4e2d\u8bfb\u53d6\u7ec4\u7ec7\u673a\u6784\u6570\u636e");
            return (List)o;
        }
        List<Map<Object, Object>> mapList = this.orgOrganisationMapper.selectTreeByOrgCode(orgCode);
        this.cacheService.put(TREEPREFIX + orgCode, mapList);
        return mapList;
    }

    @Transactional(readOnly=true)
    public List<Map<Object, Object>> selectTreeByPid(Long orgId) {
        List<Map<Object, Object>> mapList = this.orgOrganisationMapper.selectTreeByPid(orgId);
        return mapList;
    }

    @Transactional(readOnly=true)
    public PageBo<Map<Object, Object>> selectByParentID(Map<String, Object> condition, PageBo<Map<Object, Object>> page) {
        try {
            Page<Map<Object, Object>> p = new Page<Map<Object, Object>>(page);
            p.setRecords(this.orgOrganisationMapper.selectByParentID(condition, p));
            return p;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transactional(readOnly=true)
    public PageBo<Map<Object, Object>> selectByParentAutoCode(Map<String, Object> condition, PageBo<Map<Object, Object>> page) {
        Page<Map<Object, Object>> p = new Page<Map<Object, Object>>(page);
        p.setRecords(this.orgOrganisationMapper.selectByParentAutoCode(condition, p));
        return p;
    }

    @Transactional
    public Long insert(OrgOrganisation orgOrganisation) {
        if (orgOrganisation == null || orgOrganisation.getParentId() == null) {
            throw new BusException("\u6ca1\u6709\u7236\u7ec4\u7ec7\u4fe1\u606f");
        }
        int i = this.orgOrganisationMapper.selectByTitle(orgOrganisation.getTitle(), orgOrganisation.getParentId());
        if (i > 0) {
            throw new BusException("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5df2\u5b58\u5728");
        }
        OrgOrganisation parentOrg = this.selectByID(orgOrganisation.getParentId());
        if (parentOrg == null) {
            throw new BusException("\u6ca1\u6709\u7236\u7ec4\u7ec7\u4fe1\u606f");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tel", orgOrganisation.getTel());
        map.put("email", orgOrganisation.getEmail());
        map.put("fax", orgOrganisation.getFax());
        map.put("address", orgOrganisation.getAddress());
        map.put("remark", orgOrganisation.getRemark());
        map.put("linkman", orgOrganisation.getLinkman());
        orgOrganisation.setExtJson(TransJsonAndMapUtil.mapToJson(map));
        orgOrganisation.setRootId(parentOrg.getRootId());
        orgOrganisation.setDeep(Integer.valueOf(parentOrg.getDeep() + 1));
        orgOrganisation.setOrderId(Integer.valueOf(1));
        orgOrganisation.setStatus("0");
        orgOrganisation.setCreateTm(new Date());
        if (this.orgOrganisationMapper.insert(orgOrganisation) > 0) {
            String paraentCode = parentOrg.getAutoCode();
            Long orgAutoID = orgOrganisation.getAutoId();
            OrgOrganisation updateOrg = new OrgOrganisation();
            updateOrg.setAutoId(orgAutoID);
            updateOrg.setAutoCode(paraentCode + orgAutoID + "-");
            updateOrg.setOrderId(Integer.valueOf(orgAutoID.intValue()));
            this.orgOrganisationMapper.updateByID(updateOrg);
        }
        this.cacheService.delete("tree*");
        return orgOrganisation.getAutoId();
    }

    @Transactional
    public void updateByID(OrgOrganisation orgOrganisation) {
        int i = this.orgOrganisationMapper.selectByTitleNotSelf(orgOrganisation.getTitle(), orgOrganisation.getAutoId(), orgOrganisation.getParentId());
        if (i > 0) {
            throw new BusException("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u5df2\u5b58\u5728");
        }
        orgOrganisation.setUpdateTm(new Date());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tel", orgOrganisation.getTel());
        map.put("email", orgOrganisation.getEmail());
        map.put("fax", orgOrganisation.getFax());
        map.put("address", orgOrganisation.getAddress());
        map.put("remark", orgOrganisation.getRemark());
        map.put("linkman", orgOrganisation.getLinkman());
        orgOrganisation.setExtJson(TransJsonAndMapUtil.mapToJson(map));
        this.orgOrganisationMapper.updateByID(orgOrganisation);
        this.cacheService.delete("tree*");
    }

    @Transactional
    public void deleteByID(List<Long> list, String status) throws BusException {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{status}) && "1".equals(status)) {
            for (Long orgId : list) {
                this.startUsingOrg(orgId);
            }
        } else {
            if (list == null || list.size() == 0) {
                throw new BusException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
            }
            for (long autoId : list) {
                OrgOrganisation orgOrganisation = this.selectByID(autoId);
                if (orgOrganisation == null) {
                    throw new BusException("\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
                }
                Long parentId = orgOrganisation.getParentId();
                if (parentId == null || parentId == 0L) {
                    throw new BusException("\u4e0d\u80fd\u505c\u7528\u6839\u8282\u70b9");
                }
                if (this.orgOrganisationMapper.selectCountByParentID(autoId) > 0) {
                    throw new BusException("\u8be5\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u5b50\u8282\u70b9\u4fe1\u606f\u4e0d\u80fd\u505c\u7528");
                }
                if (this.orgUserMapper.queryCountsByOrgId(autoId) > 0) {
                    throw new BusException("\u8be5\u7ec4\u7ec7\u673a\u6784\u542b\u6709\u5458\u5de5\u4e0d\u80fd\u505c\u7528");
                }
                OrgOrganisation orgDelete = new OrgOrganisation();
                orgDelete.setStatus("1");
                orgDelete.setAutoId(Long.valueOf(autoId));
                this.orgOrganisationMapper.updateByID(orgDelete);
                this.authDistributeMapper.deleteAllRolesOrg(orgOrganisation.getAutoCode());
                this.cacheService.delete("tree*");
            }
        }
    }

    @Transactional
    public void deleteBatch(List<Long> list) throws BusException {
    }

    @Transactional
    public void upOrg(Long autoId) {
        OrgOrganisation currentOrg = this.selectByID(autoId);
        OrgOrganisation upOrg = this.orgOrganisationMapper.selectUpOrgByID(currentOrg.getParentId(), currentOrg.getOrderId());
        OrgOrganisation orgDept = new OrgOrganisation();
        orgDept.setAutoId(autoId);
        orgDept.setOrderId(upOrg.getOrderId());
        this.orgOrganisationMapper.updateByID(orgDept);
        orgDept = new OrgOrganisation();
        orgDept.setAutoId(upOrg.getAutoId());
        orgDept.setOrderId(currentOrg.getOrderId());
        this.orgOrganisationMapper.updateByID(orgDept);
        this.cacheService.delete("tree*");
    }

    @Transactional
    public void downOrg(Long autoId) {
        OrgOrganisation currentOrg = this.selectByID(autoId);
        OrgOrganisation downOrg = this.orgOrganisationMapper.selectDownOrgByID(currentOrg.getParentId(), currentOrg.getOrderId());
        OrgOrganisation orgDept = new OrgOrganisation();
        orgDept.setAutoId(autoId);
        orgDept.setOrderId(downOrg.getOrderId());
        this.orgOrganisationMapper.updateByID(orgDept);
        orgDept = new OrgOrganisation();
        orgDept.setAutoId(downOrg.getAutoId());
        orgDept.setOrderId(currentOrg.getOrderId());
        this.orgOrganisationMapper.updateByID(orgDept);
        this.cacheService.delete("tree*");
    }

    public String queryOrgFullName(OrgOrganisation orgOrganisation) {
        String orgCode = orgOrganisation.getAutoCode();
        String title = orgOrganisation.getTitle();
        String uptitle = "";
        while (orgCode.lastIndexOf("-") != 1) {
            orgCode = orgCode.substring(0, orgCode.length() - 1);
            OrgOrganisation organisation = this.orgOrganisationMapper.selectByAutoCode(orgCode = orgCode.substring(0, orgCode.lastIndexOf("-") + 1));
            if (organisation == null) continue;
            uptitle = organisation.getTitle();
            title = uptitle + "-" + title;
        }
        String[] split = title.split("-", 2);
        if (split.length == 2) {
            return split[1];
        }
        return title;
    }

    public String queryOrgFullName(String orgAutoCode) {
        if (StringUtils.isBlank((CharSequence)orgAutoCode)) {
            return null;
        }
        String[] autoIds = orgAutoCode.split("-");
        String orgFullName = null;
        try {
            orgFullName = this.orgOrganisationMapper.queryOrgFullName(autoIds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgFullName;
    }

    public Long queryCompId(Long orgId) {
        OrgOrganisation org = this.orgOrganisationMapper.selectByID(orgId);
        if (org.getType() == 1 || org.getType() == 3 || org.getType() == 4) {
            return org.getAutoId();
        }
        String code = org.getAutoCode();
        String[] list = code.split("-");
        for (int i = list.length - 2; i >= 0; --i) {
            OrgOrganisation org1 = this.orgOrganisationMapper.selectByID(Long.parseLong(list[i]));
            if (org1.getType() != 1 && org1.getType() != 3 && org1.getType() != 4) continue;
            return Long.parseLong(list[i]);
        }
        return null;
    }

    public void startUsingOrg(Long orgId) throws BusException {
        OrgOrganisation orgDelete = new OrgOrganisation();
        orgDelete.setStatus("0");
        orgDelete.setAutoId(orgId);
        this.orgOrganisationMapper.updateByID(orgDelete);
        this.cacheService.delete("tree*");
    }
}

