/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.org.orgstn.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.cgd.common.bo.BaseReq;
import com.cgd.manage.intfce.orgztn.bo.GetOrgFullNameReqBo;
import com.cgd.manage.intfce.orgztn.bo.GetOrgFullNamesReqBo;
import com.cgd.manage.intfce.orgztn.bo.GetOrganisationByIdsReqBO;
import com.cgd.manage.intfce.orgztn.bo.GetOrganisationBySrcCodeReqBo;
import com.cgd.manage.intfce.orgztn.bo.OrganisationRspBo;
import com.cgd.manage.intfce.orgztn.service.OrganisationBusinService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganisationBusinServiceImpl
implements OrganisationBusinService {
    @Autowired
    private OrgOrganisationMapper organisationMapper;

    public OrganisationRspBo getOrganisationById(BaseReq baseReq) {
        if (baseReq.getLongId() == null) {
            return null;
        }
        OrgOrganisation org = this.organisationMapper.selectByID(baseReq.getLongId());
        if (org == null) {
            return null;
        }
        OrganisationRspBo bo = new OrganisationRspBo();
        BeanUtils.copyProperties((Object)org, (Object)bo);
        bo.setCode(org.getCode());
        bo.setOrgId(org.getAutoId());
        bo.setSrcCode(org.getAutoCode());
        bo.setTitle(org.getTitle());
        bo.setParentId(org.getParentId());
        GetOrgFullNameReqBo getOrgFullNameReqBo = (GetOrgFullNameReqBo)baseReq.newReqBO(GetOrgFullNameReqBo.class);
        getOrgFullNameReqBo.setSrcCode(org.getAutoCode());
        OrganisationRspBo fullNameBo = this.getOrgFullName(getOrgFullNameReqBo);
        bo.setOrgFullName(fullNameBo.getOrgFullName());
        String extJson = org.getExtJson();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extJson})) {
            Map mapObj = (Map)JSONObject.parseObject((String)extJson, Map.class);
            bo.setExtProps(mapObj);
        }
        return bo;
    }

    public List<OrganisationRspBo> getOrganisationByIds(GetOrganisationByIdsReqBO getOrganisationByIdsReqBO) {
        if (getOrganisationByIdsReqBO == null || getOrganisationByIdsReqBO.getOrgIds() == null || getOrganisationByIdsReqBO.getOrgIds().isEmpty()) {
            return null;
        }
        List<OrgOrganisation> orgs = this.organisationMapper.OrganisationByIds(getOrganisationByIdsReqBO.getOrgIds());
        ArrayList<OrganisationRspBo> list = new ArrayList<OrganisationRspBo>();
        for (OrgOrganisation orgOrganisation : orgs) {
            OrganisationRspBo organisationRspBo = new OrganisationRspBo();
            BeanUtils.copyProperties((Object)orgOrganisation, (Object)organisationRspBo);
            organisationRspBo.setOrgId(orgOrganisation.getAutoId());
            organisationRspBo.setCode(orgOrganisation.getCode());
            organisationRspBo.setTitle(orgOrganisation.getTitle());
            organisationRspBo.setRegionId(orgOrganisation.getRegionId());
            String extJson = orgOrganisation.getExtJson();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extJson})) {
                Map mapObj = (Map)JSONObject.parseObject((String)extJson, Map.class);
                organisationRspBo.setExtProps(mapObj);
            }
            list.add(organisationRspBo);
        }
        return list;
    }

    public Map<Long, OrganisationRspBo> getOrganisationByIdsMap(GetOrganisationByIdsReqBO getOrganisationByIdsReqBO) {
        List<OrganisationRspBo> organisationRspBos = this.getOrganisationByIds(getOrganisationByIdsReqBO);
        HashMap<Long, OrganisationRspBo> map = new HashMap<Long, OrganisationRspBo>();
        if (organisationRspBos != null && organisationRspBos.size() > 0) {
            for (OrganisationRspBo bo : organisationRspBos) {
                map.put(bo.getOrgId(), bo);
            }
        }
        return map;
    }

    public OrganisationRspBo getOrganisationBySrcCode(GetOrganisationBySrcCodeReqBo bySrcCodeReqBo) {
        OrgOrganisation org = this.organisationMapper.selectByAutoCode(bySrcCodeReqBo.getSrcCode());
        OrganisationRspBo bo = new OrganisationRspBo();
        BeanUtils.copyProperties((Object)org, (Object)bo);
        bo.setCode(org.getCode());
        bo.setOrgId(org.getAutoId());
        bo.setSrcCode(org.getAutoCode());
        bo.setTitle(org.getTitle());
        GetOrgFullNameReqBo getOrgFullNameReqBo = new GetOrgFullNameReqBo();
        getOrgFullNameReqBo.setSrcCode(org.getAutoCode());
        OrganisationRspBo fullNameBo = this.getOrgFullName(getOrgFullNameReqBo);
        bo.setOrgFullName(fullNameBo.getOrgFullName());
        String extJson = org.getExtJson();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extJson})) {
            Map mapObj = (Map)JSONObject.parseObject((String)extJson, Map.class);
            bo.setExtProps(mapObj);
        }
        return bo;
    }

    public OrganisationRspBo getOrgFullName(GetOrgFullNameReqBo getOrgFullNameReqBo) {
        if (getOrgFullNameReqBo == null) {
            return null;
        }
        String srcCode = getOrgFullNameReqBo.getSrcCode();
        if (StringUtils.isBlank((CharSequence)srcCode)) {
            return null;
        }
        String[] autoIds = srcCode.split("-");
        StringBuilder orgFullName = new StringBuilder();
        for (String autoId : autoIds) {
            OrgOrganisation organisation = this.organisationMapper.selectByID(Long.valueOf(autoId));
            orgFullName.append(organisation == null ? "NULL" : organisation.getTitle()).append("-");
        }
        if (orgFullName.length() > 0) {
            orgFullName.deleteCharAt(orgFullName.length() - 1);
        }
        OrganisationRspBo bo = new OrganisationRspBo();
        bo.setOrgFullName(orgFullName.toString());
        return bo;
    }

    public Map<String, String> getOrgFullNames(GetOrgFullNamesReqBo getOrgFullNamesReqBo) {
        if (getOrgFullNamesReqBo == null || getOrgFullNamesReqBo.getSrcCodes() == null || getOrgFullNamesReqBo.getSrcCodes().isEmpty()) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        List srcCodes = getOrgFullNamesReqBo.getSrcCodes();
        for (String srcCode : srcCodes) {
            GetOrgFullNameReqBo getOrgFullNameReqBo = (GetOrgFullNameReqBo)getOrgFullNamesReqBo.newReqBO(GetOrgFullNameReqBo.class);
            getOrgFullNameReqBo.setSrcCode(srcCode);
            OrganisationRspBo orgFullName = this.getOrgFullName(getOrgFullNameReqBo);
            if (orgFullName == null) continue;
            result.put(srcCode, orgFullName.getOrgFullName());
        }
        return result;
    }

    public boolean isOrgBelongJHQ(BaseReq baseReq) {
        if (this.isOrgBelongJCZ(baseReq)) {
            return false;
        }
        if (this.isOrgBelongFHQ(baseReq)) {
            return false;
        }
        return this.isOrgBelongCode(baseReq, "JHQ");
    }

    public boolean isOrgBelongJCZ(BaseReq baseReq) {
        return this.isOrgBelongCode(baseReq, "JCZ");
    }

    public boolean isOrgBelongFHQ(BaseReq baseReq) {
        return this.isOrgBelongCode(baseReq, "FHQ");
    }

    private boolean isOrgBelongCode(BaseReq baseReq, String code) {
        if (baseReq == null || baseReq.getLongId() == null) {
            return false;
        }
        OrgOrganisation org = this.organisationMapper.selectByID(baseReq.getLongId());
        if (org == null || org.getAutoCode() == null) {
            return false;
        }
        String[] autoIds = org.getAutoCode().split("-");
        ArrayList<Long> pIds = new ArrayList<Long>();
        for (String pId : autoIds) {
            pIds.add(Long.valueOf(pId));
        }
        List<OrgOrganisation> porgList = this.organisationMapper.OrganisationByIds(pIds);
        if (porgList != null && !porgList.isEmpty()) {
            for (OrgOrganisation porg : porgList) {
                if (!code.equals(porg.getCode())) continue;
                return true;
            }
        }
        return false;
    }

    public OrganisationRspBo getParentOrganisation(BaseReq baseReq) {
        if (baseReq == null || baseReq.getLongId() == null) {
            return null;
        }
        OrganisationRspBo organisationRspBo = new OrganisationRspBo();
        OrgOrganisation orgOrganisation = this.organisationMapper.selectByID(baseReq.getLongId());
        if (orgOrganisation == null) {
            return null;
        }
        if (orgOrganisation.getParentId() == null) {
            BeanUtils.copyProperties((Object)orgOrganisation, (Object)organisationRspBo);
            organisationRspBo.setOrgId(orgOrganisation.getAutoId());
            organisationRspBo.setSrcCode(orgOrganisation.getAutoCode());
            return organisationRspBo;
        }
        OrgOrganisation orgOrganisationParent = this.organisationMapper.selectByID(orgOrganisation.getParentId());
        if (orgOrganisationParent == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)orgOrganisationParent, (Object)organisationRspBo);
        organisationRspBo.setOrgId(orgOrganisationParent.getAutoId());
        organisationRspBo.setSrcCode(orgOrganisationParent.getAutoCode());
        return organisationRspBo;
    }
}

