/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.org.orgstn.service.impl;

import com.cgd.common.bo.BaseReq;
import com.cgd.common.bo.ResultBeanRsp;
import com.cgd.common.bo.ResultPageRsp;
import com.cgd.common.page.Page;
import com.cgd.manage.intfce.orgztn.bo.GetOrgFullNameReqBo;
import com.cgd.manage.intfce.orgztn.bo.GetOrganisationBySrcCodeReqBo;
import com.cgd.manage.intfce.orgztn.bo.OrganisationRspBo;
import com.cgd.manage.intfce.orgztn.bo.QueryDeptsReqBo;
import com.cgd.manage.intfce.orgztn.service.OrganisationBusinService;
import com.cgd.manage.intfce.orgztn.service.OrganisationCombiService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgCompanBo;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrganisationCombiServiceImpl
implements OrganisationCombiService {
    @Autowired
    private OrganisationBusinService organisationBusinService;
    @Autowired
    private OrgOrganisationMapper organisationMapper;

    public ResultPageRsp<OrganisationRspBo> queryCompanys(OrgCompanBo baseReq) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(baseReq.getCurrentPage(), baseReq.getPageSize());
        List<Map<String, Object>> dataList = this.organisationMapper.queryCompanys(baseReq.getCompName(), page);
        ArrayList<OrganisationRspBo> rspBos = new ArrayList<OrganisationRspBo>();
        if (dataList != null && !dataList.isEmpty()) {
            ArrayList<String> srcCodeList = new ArrayList<String>();
            for (Map<String, Object> map : dataList) {
                OrganisationRspBo bo = new OrganisationRspBo();
                bo.setCode((String)map.get("code"));
                bo.setOrgId((Long)map.get("auto_id"));
                bo.setSrcCode((String)map.get("auto_code"));
                bo.setTitle((String)map.get("title"));
                srcCodeList.add(bo.getSrcCode());
                rspBos.add(bo);
            }
        }
        ResultPageRsp rsp = new ResultPageRsp();
        rsp.setRows(rspBos);
        rsp.setTotalPage(page.getTotalPage());
        rsp.setTotalRecord(page.getTotalRecord());
        return rsp;
    }

    public ResultPageRsp<OrganisationRspBo> queryDepts(QueryDeptsReqBo deptsReqBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(deptsReqBo.getCurrentPage(), deptsReqBo.getPageSize());
        List<Map<String, Object>> dataList = this.organisationMapper.queryDepts(deptsReqBo.getDeptName(), page);
        ArrayList<OrganisationRspBo> rspBos = new ArrayList<OrganisationRspBo>();
        if (dataList != null && !dataList.isEmpty()) {
            for (Map<String, Object> map : dataList) {
                OrganisationRspBo bo = new OrganisationRspBo();
                bo.setCode((String)map.get("code"));
                bo.setOrgId((Long)map.get("auto_id"));
                bo.setSrcCode((String)map.get("auto_code"));
                bo.setTitle((String)map.get("title"));
                GetOrgFullNameReqBo getOrgFullNameReqBo = new GetOrgFullNameReqBo();
                getOrgFullNameReqBo.setSrcCode(bo.getSrcCode());
                OrganisationRspBo fullNameBo = this.organisationBusinService.getOrgFullName(getOrgFullNameReqBo);
                bo.setOrgFullName(fullNameBo.getOrgFullName());
                rspBos.add(bo);
            }
        }
        ResultPageRsp rsp = new ResultPageRsp();
        rsp.setRows(rspBos);
        rsp.setTotalPage(page.getTotalPage());
        rsp.setTotalRecord(page.getTotalRecord());
        return rsp;
    }

    public ResultBeanRsp<OrganisationRspBo> getOrganisationById(BaseReq baseReq) {
        OrganisationRspBo orgbo = this.organisationBusinService.getOrganisationById(baseReq);
        ResultBeanRsp rsp = new ResultBeanRsp();
        if (orgbo != null) {
            rsp.setRow((Object)orgbo);
        }
        return rsp;
    }

    public ResultBeanRsp<OrganisationRspBo> getOrganisationBySrcCode(GetOrganisationBySrcCodeReqBo bySrcCodeReqBo) {
        OrganisationRspBo orgbo = this.organisationBusinService.getOrganisationBySrcCode(bySrcCodeReqBo);
        ResultBeanRsp rsp = new ResultBeanRsp();
        rsp.setRow((Object)orgbo);
        return rsp;
    }

    public OrgOrganisation selectOrganisationByID(Long autoId) {
        return this.organisationMapper.selectByID(autoId);
    }
}

