/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.org.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.PageBo;
import com.cgd.common.exception.BusException;
import com.cgd.common.page.Page;
import com.cgd.common.utils.MD5Utils;
import com.cgd.manage.auth.distrbt.dao.AuthDistributeMapper;
import com.cgd.manage.auth.distrbt.po.AuthDistribute;
import com.cgd.manage.auth.group.dao.AuthGroupUserMapper;
import com.cgd.manage.auth.role.dao.AuthRoleAdmMapper;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.manage.org.emp.dao.OrgEmployeMapper;
import com.cgd.manage.org.emp.po.OrgEmploye;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.orgstn.service.OrgOrganisationService;
import com.cgd.manage.org.user.dao.OrgUserMapper;
import com.cgd.manage.org.user.po.OrgUser;
import com.cgd.manage.org.user.service.OrgUserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgUserServiceImpl
implements OrgUserService {
    @Autowired
    private OrgUserMapper orgUserMapper;
    @Autowired
    private OrgOrganisationMapper orgOrganisationMapper;
    @Autowired
    private OrgOrganisationService orgOrganisationService;
    @Autowired
    private AuthDistributeMapper authDistributeMapper;
    @Autowired
    private AuthRoleAdmMapper authRoleAdmMapper;
    @Autowired
    private AuthGroupUserMapper authGroupUserMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private OrgEmployeMapper employeMapper;
    @Value(value="${adminSecondRole}")
    private long admRoleId;
    @Value(value="${adminSecondPortalRole}")
    private long portalRole;
    @Value(value="${defaultPassword}")
    private String DEFAULT_PASSWORD;

    @Transactional(readOnly=true)
    public OrgUser getUserByLoginname(String loginName) {
        return this.orgUserMapper.selectByLoginname(loginName);
    }

    @Transactional(readOnly=true)
    public OrgUser selectByID(Long userId) {
        return this.orgUserMapper.selectByID(userId);
    }

    public OrgEmploye selectOrgEmployeByID(Long userId) {
        return this.orgUserMapper.selectOrgEmployeByID(userId);
    }

    @Transactional(readOnly=true)
    public Map<String, Object> selectTextByID(Long userId) {
        Map<String, Object> result = this.orgUserMapper.selectTextByID(userId);
        Map valueByCode = this.dicDictionaryService.getValueByCode("EMP_STATION");
        if (valueByCode != null) {
            String stationName = (String)valueByCode.get((String)result.get("station"));
            result.put("stationName", stationName);
        }
        return result;
    }

    @Transactional(readOnly=true)
    public PageBo<Map<String, Object>> selectByOrgAutoCode(String orgAutoCode, Map<String, Object> condition, PageBo<Map<String, Object>> pageBo) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Map<String, Object>> dataList = this.orgUserMapper.selectByOrgAutoCode(orgAutoCode, condition, page);
        if (dataList != null && !dataList.isEmpty()) {
            for (Map<String, Object> data : dataList) {
                String code = (String)data.get("autoCode");
                String orgFullName = this.orgOrganisationService.queryOrgFullName(code);
                data.put("orgFullName", orgFullName);
            }
        }
        page.setRecords(dataList);
        return page;
    }

    @Transactional
    public void insert(OrgUser orgUser, String orgEmployeJson) {
        int i;
        OrgUser user = this.orgUserMapper.selectByLoginname(orgUser.getLoginname());
        if (user != null) {
            throw new BusException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        OrgEmploye orgEmploye = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgEmployeJson})) {
            orgEmploye = (OrgEmploye)JSON.parseObject((String)orgEmployeJson, OrgEmploye.class);
            OrgUser userCodeInfo = this.orgUserMapper.selectByUsercode(orgEmploye.getUsercode());
            if (userCodeInfo != null) {
                throw new BusException("\u5458\u5de5\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
            }
            this.employeMapper.insert(orgEmploye);
        }
        orgUser.setCreateTm(new Date());
        String password = this.DEFAULT_PASSWORD;
        if (StringUtils.isNotBlank((CharSequence)orgUser.getPassword())) {
            password = orgUser.getPassword();
        }
        String md5pwd = MD5Utils.md5(password);
        orgUser.setPassword(md5pwd);
        if (orgEmploye != null) {
            orgUser.setEmpId(orgEmploye.getAutoId());
        }
        if ((i = this.orgUserMapper.insert(orgUser)) > 0) {
            user = this.orgUserMapper.selectByLoginname(orgUser.getLoginname());
            AuthDistribute authDistribute = new AuthDistribute();
            authDistribute.setRoleId(Long.valueOf(this.admRoleId));
            authDistribute.setUserId(user.getUserId());
            authDistribute.setDisFlag(Integer.valueOf(1));
            authDistribute.setCreateTm(new Date());
            this.authDistributeMapper.insertSelective(authDistribute);
            authDistribute.setRoleId(Long.valueOf(this.portalRole));
            this.authDistributeMapper.insertSelective(authDistribute);
        }
    }

    @Transactional
    public Long saveUser(OrgUser orgUser, OrgEmploye orgEmploye) {
        OrgUser user = this.orgUserMapper.selectByLoginname(orgUser.getLoginname());
        if (user != null) {
            throw new BusException("\u7528\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        user = this.orgUserMapper.selectByLoginnameLoseEfficacy(orgUser.getLoginname());
        if (user != null) {
            throw new BusException("\u7528\u6237\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        OrgUser userCodeInfo = this.orgUserMapper.selectByUsercode(orgEmploye.getUsercode());
        if (userCodeInfo != null) {
            throw new BusException("\u5458\u5de5\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        this.employeMapper.insert(orgEmploye);
        orgUser.setEmpId(orgEmploye.getAutoId());
        String password = this.DEFAULT_PASSWORD;
        if (StringUtils.isNotBlank((CharSequence)orgUser.getPassword())) {
            password = orgUser.getPassword();
        }
        String md5pwd = MD5Utils.md5(password);
        orgUser.setPassword(md5pwd);
        this.orgUserMapper.insert(orgUser);
        return orgUser.getUserId();
    }

    @Transactional
    public void updateUser(OrgUser orgUser, OrgEmploye orgEmploye) {
        this.employeMapper.updateByID(orgEmploye);
        this.orgUserMapper.updateByID(orgUser);
    }

    @Transactional
    public void deleteUser(List<Long> userIdList, String status) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{status}) && "1".equals(status)) {
            for (Long autoId : userIdList) {
                OrgEmploye orgEmploye = new OrgEmploye();
                orgEmploye.setAutoId(autoId);
                orgEmploye.setDelFlag(DEL_FLAG_0);
                OrgUser user = this.orgUserMapper.selectByID(autoId);
                if (user == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{user.getLoginname()})) continue;
                if ((user = this.orgUserMapper.selectByLoginname(user.getLoginname())) == null) {
                    this.employeMapper.updateByID(orgEmploye);
                    this.orgUserMapper.startByUserID(autoId);
                    continue;
                }
                throw new BusException("\u5b58\u5728\u76f8\u540c\u7528\u6237\u540d\uff0c\u542f\u7528\u5931\u8d25");
            }
        } else {
            List<Long> autoIdList = this.orgUserMapper.selectEmpIdByUserIds(userIdList);
            this.employeMapper.deleteByIDs(autoIdList);
            this.orgUserMapper.deleteByUserIDs(userIdList);
            this.authDistributeMapper.deleteByUser(userIdList);
            this.authGroupUserMapper.deleteUserGroup(userIdList);
        }
    }

    @Transactional
    public void updateByID(OrgUser orgUser, String orgEmployeJson) {
        orgUser.setUpdateTm(new Date());
        this.orgUserMapper.updateByID(orgUser);
        OrgUser user = this.orgUserMapper.selectByID(orgUser.getUserId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{orgEmployeJson})) {
            OrgEmploye orgEmploye = (OrgEmploye)JSON.parseObject((String)orgEmployeJson, OrgEmploye.class);
            orgEmploye.setAutoId(user.getEmpId());
            this.employeMapper.updateByID(orgEmploye);
        }
    }

    @Transactional
    public void delete(Long userId) {
        OrgUser user = this.selectByID(userId);
        if (user == null) {
            throw new BusException("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (DEL_FLAG_1 == user.getDelFlag()) {
            throw new BusException("\u7528\u6237 \u5df2\u5220\u9664");
        }
        OrgUser orgUser = new OrgUser();
        orgUser.setUserId(userId);
        orgUser.setDelFlag(DEL_FLAG_1);
        this.orgUserMapper.updateByID(orgUser);
    }

    @Transactional
    public void resetPassword(List<Long> userIdList) {
        if (userIdList == null || userIdList.size() == 0) {
            throw new BusException("\u53c2\u6570\u9519\u8bef");
        }
        String password = MD5Utils.md5(this.DEFAULT_PASSWORD);
        this.orgUserMapper.resetPassword(password, userIdList);
    }

    @Transactional
    public int updateAdmOrgID(OrgUser orgUser) {
        int i = this.orgUserMapper.updateAdmOrgID(orgUser);
        return i;
    }

    @Transactional(readOnly=true)
    public PageBo<OrgUser> queryUsers(PageBo<OrgUser> pageBo, String queryLike) {
        Page<OrgUser> page = new Page<OrgUser>(pageBo);
        List<OrgUser> orgUsers = this.orgUserMapper.queryUsers(page, queryLike);
        for (OrgUser orgUser : orgUsers) {
            OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgUser.getAdmOrgid());
            if (orgOrganisation == null) continue;
            String orgFullName = this.orgOrganisationService.queryOrgFullName(orgOrganisation);
            orgUser.setOrgName(orgFullName);
        }
        page.setRecords(orgUsers);
        return page;
    }

    @Transactional
    public void deleteByPrimaryKeys(Long[] userIds, String status) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{status}) && "1".equals(status)) {
            for (Long userId : userIds) {
                this.orgUserMapper.startUsingByPrimaryKeys(userId);
            }
        } else {
            this.orgUserMapper.deleteByPrimaryKeys(userIds);
            for (int i = 0; i < userIds.length; ++i) {
                this.authRoleAdmMapper.deleteByAdmUserId(userIds[i]);
            }
        }
    }

    @Transactional
    public PageBo<Map<String, Object>> getOrg(PageBo<Map<String, Object>> pageBo, boolean flag, Long uid, String queryStr, String type) {
        Page<Map<String, Object>> page = new Page<Map<String, Object>>(pageBo);
        List<Object> datalist = new ArrayList();
        if (flag) {
            datalist = this.authDistributeMapper.selectOrg(queryStr, null, type, page);
        } else {
            OrgUser orgUser = this.orgUserMapper.selectByID(uid);
            OrgOrganisation orgOrganisation = this.orgOrganisationMapper.selectByID(orgUser.getAdmOrgid());
            datalist = this.authDistributeMapper.selectOrg(queryStr, orgOrganisation.getAutoCode(), type, page);
        }
        for (Map map : datalist) {
            map.put("orgTitle", this.orgOrganisationService.queryOrgFullName((String)map.get("orgAutoCode")));
        }
        page.setRecords(datalist);
        return page;
    }

    @Transactional
    public void updateUserAsAdmin(Long userId) {
        OrgUser selectByID = this.orgUserMapper.selectByID(userId);
        OrgUser orgUser = new OrgUser();
        orgUser.setAdmOrgid(selectByID.getOrgId());
        orgUser.setAdmFlag(ADM_FLAG_1);
        orgUser.setUserId(userId);
        int updateByID = this.orgUserMapper.updateByID(orgUser);
        if (updateByID >= 0) {
            AuthDistribute record = new AuthDistribute();
            record.setUserId(userId);
            record.setRoleId(SEC_ADM_ROLE_ID);
            record.setDisFlag(AUTH_DIS_FLAG_1);
            record.setCreateTm(new Date());
            this.authDistributeMapper.insert(record);
        }
    }
}

