/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.manage.org.user.service.impl;

import com.cgd.common.bo.BaseReq;
import com.cgd.manage.intfce.user.bo.GetUserByLoginNameReqBo;
import com.cgd.manage.intfce.user.bo.QueryUsersByIDSReqBo;
import com.cgd.manage.intfce.user.bo.UserRspBo;
import com.cgd.manage.intfce.user.service.UserBusinService;
import com.cgd.manage.org.orgstn.dao.OrgOrganisationMapper;
import com.cgd.manage.org.orgstn.po.OrgOrganisation;
import com.cgd.manage.org.user.dao.OrgUserMapper;
import com.cgd.manage.org.user.po.OrgUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserBusinServiceImpl
implements UserBusinService {
    @Autowired
    private OrgUserMapper orgUserMapper;
    @Autowired
    private OrgOrganisationMapper organisationMapper;

    public UserRspBo getUserByLoginName(GetUserByLoginNameReqBo loginName) {
        OrgUser orgUser = this.orgUserMapper.selectByLoginname(loginName.getLoginName());
        if (orgUser == null) {
            return null;
        }
        UserRspBo userRspBo = new UserRspBo();
        userRspBo.setEmpId(orgUser.getEmpId());
        userRspBo.setJobName(null);
        userRspBo.setLoginname(orgUser.getLoginname());
        userRspBo.setName(orgUser.getName());
        userRspBo.setOrgId(orgUser.getOrgId());
        userRspBo.setUserId(orgUser.getUserId());
        return userRspBo;
    }

    public UserRspBo getUserByUserId(BaseReq userLongIdReq) {
        OrgUser selectByID = this.orgUserMapper.selectByID(userLongIdReq.getLongId());
        if (selectByID == null) {
            return null;
        }
        UserRspBo userRspBo = new UserRspBo();
        userRspBo.setEmpId(selectByID.getEmpId());
        userRspBo.setLoginname(selectByID.getLoginname());
        userRspBo.setName(selectByID.getName());
        userRspBo.setUserId(selectByID.getUserId());
        userRspBo.setOrgId(selectByID.getOrgId());
        OrgOrganisation dept = this.organisationMapper.selectByID(selectByID.getOrgId());
        if (dept != null) {
            userRspBo.setDeptName(dept.getTitle());
        }
        return userRspBo;
    }

    public List<UserRspBo> getUserByUserIds(QueryUsersByIDSReqBo queryUsersByIDSReqBo) {
        List userIDs = queryUsersByIDSReqBo.getUserIDs();
        if (userIDs == null || userIDs.size() <= 0) {
            return null;
        }
        List<OrgUser> resultList = this.orgUserMapper.selectByIDs(userIDs);
        if (resultList == null || resultList.size() <= 0) {
            return null;
        }
        ArrayList<UserRspBo> boList = new ArrayList<UserRspBo>();
        for (OrgUser user : resultList) {
            UserRspBo userRspBo = new UserRspBo();
            BeanUtils.copyProperties((Object)user, (Object)userRspBo);
            OrgOrganisation dept = this.organisationMapper.selectByID(user.getOrgId());
            if (dept != null) {
                userRspBo.setDeptName(dept.getTitle());
            }
            boList.add(userRspBo);
        }
        return boList;
    }

    public Map<Long, UserRspBo> getUserByIdsMap(QueryUsersByIDSReqBo queryUsersByIDSReqBo) {
        List<UserRspBo> userRspBos = this.getUserByUserIds(queryUsersByIDSReqBo);
        HashMap<Long, UserRspBo> map = new HashMap<Long, UserRspBo>();
        if (userRspBos != null && userRspBos.size() > 0) {
            for (UserRspBo bo : userRspBos) {
                map.put(bo.getUserId(), bo);
            }
        }
        return map;
    }
}

