/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.Vector;

public class HsfResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String message;
    private T data;
    private static final String SUCCESS_CODE = "0000";
    private static final String ERROR_CODE = "8888";
    private static final String RSP_CODE_KEY = "RetCode";
    private static final String RSP_MESSAGE_KEY = "RetDesc";
    private static final String RSP_DATA_KEY = "DataRows";

    private HsfResult() {
    }

    private HsfResult(String code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static HsfResult getInstance() {
        return new HsfResult();
    }

    public static HsfResult success() {
        return new HsfResult<Object>(SUCCESS_CODE, null, null);
    }

    public static HsfResult success(String message) {
        return new HsfResult<Object>(SUCCESS_CODE, message, null);
    }

    public static HsfResult success(JSON data) {
        return new HsfResult<JSON>(SUCCESS_CODE, null, data);
    }

    public static HsfResult success(Object data) {
        return new HsfResult<Object>(SUCCESS_CODE, null, data);
    }

    public static HsfResult fail() {
        return new HsfResult<Object>(ERROR_CODE, null, null);
    }

    public static HsfResult fail(String message) {
        return new HsfResult<Object>(ERROR_CODE, message, null);
    }

    public static HsfResult fail(String errorCode, String errorMsg) {
        return new HsfResult<Object>(errorCode, errorMsg, null);
    }

    public static HsfResult fail(String message, Object data) {
        return new HsfResult<Object>(ERROR_CODE, message, data);
    }

    public static HsfResult page(long totalElements, int totalPages, JSONArray content) {
        JSONObject data = new JSONObject();
        data.put("totalElements", (Object)totalElements);
        data.put("totalPages", (Object)totalPages);
        data.put("content", (Object)content);
        return new HsfResult<JSONObject>(SUCCESS_CODE, null, data);
    }

    public static HsfResult<String> errorRes(String message) {
        return HsfResult.fail(message);
    }

    public static HsfResult<String> errorResArray(Vector<Vector<String>> vectors) {
        if (vectors.size() <= 0) {
            return HsfResult.fail();
        }
        String errmess = "";
        JSONArray errorArr = new JSONArray();
        for (int i = 0; i < vectors.size(); ++i) {
            JSONObject obj = new JSONObject();
            for (int j = 0; j < vectors.get(i).size(); ++j) {
                errmess = errmess + vectors.get(i).get(j) + ",";
            }
            obj.put("message", (Object)errmess.substring(0, errmess.length() - 1));
            if (vectors.size() <= 1) {
                return HsfResult.fail(obj.getString("message"));
            }
            errorArr.add((Object)obj);
        }
        return HsfResult.fail(errorArr.toString());
    }

    public boolean isSuccess() {
        return SUCCESS_CODE.equals(this.code);
    }

    public JSONObject toJSONObject() {
        JSONObject object = new JSONObject();
        object.put(RSP_CODE_KEY, (Object)this.code);
        object.put(RSP_MESSAGE_KEY, (Object)this.message);
        object.put(RSP_DATA_KEY, this.data);
        return object;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

