/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.Map;

public class BeanAndMapUtil {
    public static <T> T mapToBean(Map<String, Object> map, Class<?> clazz) throws Exception {
        Object obj = clazz.newInstance();
        if (map != null && !map.isEmpty() && map.size() > 0) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String propertyName = entry.getKey();
                Object value = entry.getValue();
                String setMethodName = "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                Field field = BeanAndMapUtil.getClassField(clazz, propertyName);
                if (field == null) continue;
                Class<?> fieldTypeClass = field.getType();
                value = BeanAndMapUtil.convertValType(value, fieldTypeClass);
                try {
                    clazz.getMethod(setMethodName, field.getType()).invoke(obj, value);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
        }
        return (T)obj;
    }

    private static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] declaredFields;
        if (Object.class.getName().equals(clazz.getName())) {
            return null;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            return BeanAndMapUtil.getClassField(superClass, fieldName);
        }
        return null;
    }

    private static Object convertValType(Object value, Class<?> fieldTypeClass) {
        Object retVal = null;
        retVal = Long.class.getName().equals(fieldTypeClass.getName()) || Long.TYPE.getName().equals(fieldTypeClass.getName()) ? Long.valueOf(Long.parseLong(value.toString())) : (Integer.class.getName().equals(fieldTypeClass.getName()) || Integer.TYPE.getName().equals(fieldTypeClass.getName()) ? Integer.valueOf(Integer.parseInt(value.toString())) : (Float.class.getName().equals(fieldTypeClass.getName()) || Float.TYPE.getName().equals(fieldTypeClass.getName()) ? Float.valueOf(Float.parseFloat(value.toString())) : (Double.class.getName().equals(fieldTypeClass.getName()) || Double.TYPE.getName().equals(fieldTypeClass.getName()) ? Double.valueOf(Double.parseDouble(value.toString())) : value)));
        return retVal;
    }

    public static Map<?, ?> objectToMap(Object object) {
        return BeanAndMapUtil.convertBean(object, Map.class);
    }

    public static <T> T convertBean(Object object, Class<T> entityClass) {
        if (null == object) {
            return null;
        }
        return (T)JSONObject.parseObject((String)JSONObject.toJSONString((Object)object), entityClass);
    }
}

