/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class ComUtil {
    private static final Map<String, Marshaller> mashallerMap = Collections.synchronizedMap(new HashMap());
    private static final String NULL_STRING = "";

    private ComUtil() {
    }

    public static List<Object> arrayToList(Object[] array) {
        if (ComUtil.isEmpty(array)) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object obj : array) {
            list.add(obj);
        }
        return list;
    }

    public static boolean checkDateFormatAndValite(String strDateTime) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
            Date ndate = format.parse(strDateTime);
            String str = format.format(ndate);
            return str.equals(strDateTime);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isEmpty(Object emptyObect) {
        boolean result = true;
        if (emptyObect == null) {
            return true;
        }
        if (emptyObect instanceof String) {
            result = emptyObect.toString().trim().length() == 0 || emptyObect.toString().trim().equals("null");
        } else if (emptyObect instanceof Collection) {
            result = ((Collection)emptyObect).isEmpty();
        } else if (emptyObect instanceof JSONObject) {
            result = ((JSONObject)emptyObect).isEmpty();
        } else if (emptyObect.toString().trim().length() >= 1) {
            result = false;
        }
        return result;
    }

    public static boolean checkDateFormatAndValite(String strDateTime, String type) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(type);
            Date ndate = format.parse(strDateTime);
            String str = format.format(ndate);
            return str.equals(strDateTime);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String exception2String(Throwable t) throws IOException {
        if (t == null) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            t.printStackTrace(new PrintStream(baos));
            String string = baos.toString();
            return string;
        }
    }

    public static String formatDate(Date date) {
        return ComUtil.formatDate(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDate(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        if (date != null) {
            return simpleDateFormat.format(date);
        }
        return null;
    }

    public static Date parseDate(String date, String format) {
        if (ComUtil.isEmpty(date)) {
            return null;
        }
        if (ComUtil.isEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        Date resultDate = null;
        try {
            resultDate = simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            e.getMessage();
        }
        return resultDate;
    }

    public static synchronized String mashallerObj2Str4Jaxb(Object obj, Class<?> clazz) {
        String str = NULL_STRING;
        try (StringWriter writerStr = new StringWriter();){
            Marshaller mashaller = mashallerMap.get(clazz.getName());
            if (mashaller == null) {
                mashaller = JAXBContext.newInstance((Class[])new Class[]{clazz}).createMarshaller();
                mashallerMap.put(clazz.getName(), mashaller);
            }
            mashaller.marshal(obj, (Writer)writerStr);
            str = writerStr.getBuffer().toString();
        }
        catch (JAXBException e2) {
            e2.getMessage();
        }
        catch (IOException e) {
            e.getMessage();
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(HttpServletResponse response, String content) {
        response.reset();
        try (PrintWriter out = null;){
            response.setContentType("text/html;charset=utf-8");
            out = response.getWriter();
            out.println(content);
            out.flush();
        }
    }

    public static boolean isNotEmpty(Object str) {
        return !ComUtil.isEmpty(str);
    }

    public static String killNull(BigDecimal o) {
        return ComUtil.killNull(o, NULL_STRING);
    }

    public static String killNull(Double o) {
        return ComUtil.killNull(o, NULL_STRING);
    }

    public static String killNull(long o) {
        return String.valueOf(o);
    }

    public static String killNull(Long o) {
        return o == null ? NULL_STRING : String.valueOf(o);
    }

    public static String killNull(Object o) {
        return ComUtil.killNull(o, NULL_STRING);
    }

    public static String list2String(List list, String seperator) {
        if (list.isEmpty()) {
            return NULL_STRING;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(seperator);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static String[] stringToStrArray(String input, String delimiter) {
        if (ComUtil.isEmpty(input)) {
            return null;
        }
        return input.split(delimiter);
    }

    public static String killNull(Object o, String ds) {
        return o != null ? String.valueOf(o) : ds;
    }

    public static boolean isNumber(String str) {
        try {
            if (ComUtil.isEmpty(str)) {
                return false;
            }
            new Double(str);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Date parseDateFormat(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        if (str.length() == 6) {
            return ComUtil.parseDate(str, "yyyyMM");
        }
        if (str.length() == 7) {
            return ComUtil.parseDate(str, "yyyy-MM");
        }
        if (str.length() == 10) {
            return ComUtil.parseDate(str, "yyyy-MM-dd");
        }
        if (str.length() == 9) {
            if (ComUtil.parseDate(str, "yyyy-MM-d") == null) {
                return ComUtil.parseDate(str, "yyyy-M-dd");
            }
            return ComUtil.parseDate(str, "yyyy-MM-d");
        }
        if (str.length() == 8) {
            return ComUtil.parseDate(str, "yyyy-M-d");
        }
        if (str.length() == 13) {
            return ComUtil.parseDate(str, "yyyy-MM-dd HH");
        }
        if (str.length() == 14) {
            return ComUtil.parseDate(str, "yyyyMMddHHmmss");
        }
        if (str.length() == 16) {
            return ComUtil.parseDate(str, "yyyy-MM-dd HH:mm");
        }
        if (str.length() == 19) {
            return ComUtil.parseDate(str, "yyyy-MM-dd HH:mm:ss");
        }
        if (str.length() >= 21) {
            return ComUtil.parseDate(str, "yyyy-MM-dd HH:mm:ss.S");
        }
        return null;
    }

    public static Date getFinalDate() {
        return ComUtil.parseDateFormat("20991231235959");
    }

    public static String finalDate() {
        return "20991231235959";
    }

    public static String nowDate(Date date) {
        return ComUtil.formatDate(date, "yyyyMMddHHmmss");
    }

    public static String formatStand(String date) {
        return ComUtil.formatDate(ComUtil.parseDateFormat(date), "yyyyMMddHHmmss");
    }
}

