/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CommonUtils {
    public static boolean isEmpty(Object emptyObect) {
        boolean result = true;
        if (emptyObect == null) {
            return true;
        }
        result = emptyObect instanceof String ? emptyObect.toString().trim().length() == 0 || emptyObect.toString().trim().equals("null") : (emptyObect instanceof Collection ? ((Collection)emptyObect).size() == 0 : emptyObect == null || emptyObect.toString().trim().length() < 1);
        return result;
    }

    public static boolean isNotEmpty(Object str) {
        return !CommonUtils.isEmpty(str);
    }

    public static String loadProductTypeCode(String type) {
        if (StringUtils.isNotEmpty((String)type)) {
            if (type.equals("yun")) {
                return "1";
            }
            if (type.equals("idc")) {
                return "2";
            }
            if (type.equals("jichu")) {
                return "3";
            }
            if (type.equals("hulianwang")) {
                return "4";
            }
            if (type.equals("wulianwang")) {
                return "6";
            }
            if (type.equals("dashuju")) {
                return "7";
            }
            if (type.equals("ict")) {
                return "8";
            }
        }
        return "";
    }

    public static String checkRegion(String type) {
        String gridType = "";
        switch (type) {
            case "211": {
                gridType = "city";
                break;
            }
            case "212": {
                gridType = "city";
                break;
            }
            case "213": {
                gridType = "city";
                break;
            }
            case "214": {
                gridType = "city";
                break;
            }
            case "225": {
                gridType = "city";
                break;
            }
            case "226": {
                gridType = "city";
                break;
            }
            case "216": {
                gridType = "near";
                break;
            }
            case "217": {
                gridType = "near";
                break;
            }
            case "218": {
                gridType = "near";
                break;
            }
            case "219": {
                gridType = "near";
                break;
            }
            case "220": {
                gridType = "near";
                break;
            }
            case "215": {
                gridType = "far";
                break;
            }
            case "221": {
                gridType = "far";
                break;
            }
            case "222": {
                gridType = "far";
                break;
            }
            case "223": {
                gridType = "far";
                break;
            }
            case "224": {
                gridType = "far";
                break;
            }
        }
        return gridType;
    }

    public static String getPageSql(String sql, int pageNum, int pageSize) {
        int startNum = (pageNum - 1) * pageSize + 1;
        int endNum = pageNum * pageSize;
        StringBuilder jpql = new StringBuilder();
        jpql.append("select * from (");
        jpql.append("select row_.*,ROWNUM rownum_ from (");
        jpql.append(sql);
        jpql.append(") row_ where ROWNUM <= " + endNum);
        jpql.append(") where rownum_ >= " + startNum);
        return jpql.toString();
    }

    public static String killNull(Object o, String ds) {
        if (o instanceof Double) {
            return CommonUtils.killNull((Double)o, ds);
        }
        return o != null ? o.toString() : ds;
    }

    public static String killNull(Object o) {
        return CommonUtils.killNull(o, "");
    }

    public static String killNull(Double o) {
        return CommonUtils.killNull(o, "");
    }

    public static String killNull(BigDecimal o) {
        return CommonUtils.killNull(o, "");
    }

    public static String killNull(long o) {
        return String.valueOf(o);
    }

    public static String killNull(Long o) {
        return o == null ? "" : String.valueOf(o);
    }

    public static String getOptionHtml(List<Object[]> list) {
        StringBuilder sb = new StringBuilder("<option value=\"\">--\u8bf7\u9009\u62e9--</option>");
        if (list != null && list.size() > 0) {
            for (Object[] obj : list) {
                sb.append("<option value='" + obj[0] + "'>" + obj[1] + "</option>");
            }
        }
        return sb.toString();
    }

    public static String transIndustry(String hangyeRole) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        if (CommonUtils.isNotEmpty(hangyeRole) && (arr = hangyeRole.split(",")) != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                String industry;
                if (!CommonUtils.isNotEmpty(arr[i]) || !CommonUtils.isNotEmpty(industry = CommonUtils.loadBFIndustry(arr[i]))) continue;
                list.add(industry);
            }
        }
        return CommonUtils.listToString(list, ",");
    }

    public static String listToString(List list, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i)).append(separator);
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String loadBFIndustry(String roleOrder) {
        if (CommonUtils.isNotEmpty(roleOrder)) {
            if (roleOrder.equals("500") || roleOrder.equals("100")) {
                return "10000";
            }
            if (roleOrder.equals("501") || roleOrder.equals("101")) {
                return "10001";
            }
            if (roleOrder.equals("502") || roleOrder.equals("102")) {
                return "10002";
            }
            if (roleOrder.equals("503") || roleOrder.equals("103")) {
                return "10003";
            }
            if (roleOrder.equals("504") || roleOrder.equals("104")) {
                return "10004";
            }
            if (roleOrder.equals("505") || roleOrder.equals("105")) {
                return "10005";
            }
            if (roleOrder.equals("506") || roleOrder.equals("106")) {
                return "10006";
            }
            if (roleOrder.equals("507") || roleOrder.equals("107")) {
                return "10007";
            }
        }
        return "";
    }

    public static String loadRoleOrder(String roleOrder) {
        if (CommonUtils.isNotEmpty(roleOrder)) {
            if (roleOrder.equals("10000")) {
                return "500";
            }
            if (roleOrder.equals("10001")) {
                return "501";
            }
            if (roleOrder.equals("10002")) {
                return "502";
            }
            if (roleOrder.equals("10003")) {
                return "503";
            }
            if (roleOrder.equals("10004")) {
                return "504";
            }
            if (roleOrder.equals("10005")) {
                return "505";
            }
            if (roleOrder.equals("10006")) {
                return "506";
            }
            if (roleOrder.equals("10007")) {
                return "507";
            }
        }
        return "";
    }

    public static String loadBFIndustryName(String roleOrder) {
        if (CommonUtils.isNotEmpty(roleOrder)) {
            if (roleOrder.equals("500") || roleOrder.equals("100")) {
                return "\u91d1\u878d";
            }
            if (roleOrder.equals("501") || roleOrder.equals("101")) {
                return "\u515a\u653f\u519b";
            }
            if (roleOrder.equals("502") || roleOrder.equals("102")) {
                return "\u6559\u80b2";
            }
            if (roleOrder.equals("503") || roleOrder.equals("103")) {
                return "\u533b\u536b";
            }
            if (roleOrder.equals("504") || roleOrder.equals("104")) {
                return "\u4ea4\u901a\u65c5\u6e38\u5546\u8d85";
            }
            if (roleOrder.equals("505") || roleOrder.equals("105")) {
                return "\u80fd\u6e90\u5236\u9020";
            }
            if (roleOrder.equals("506") || roleOrder.equals("106")) {
                return "\u4e92\u8054\u7f51";
            }
            if (roleOrder.equals("507") || roleOrder.equals("107")) {
                return "\u5176\u4ed6";
            }
        }
        return "";
    }
}

