/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    public static String getDateBefore(Date date, int day) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.set(5, now.get(5) - day);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateTime = dateFormat.format(now.getTime());
        return dateTime;
    }

    public static Boolean DateAfter(Date afterDate, String before) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date beforeDate = df.parse(before);
            return afterDate.after(beforeDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getDateOfLastMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar lastDate = (Calendar)c.clone();
        lastDate.add(2, -1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(lastDate.getTime());
    }

    public static String getLastMonthFirst(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar lastDate = (Calendar)c.clone();
        lastDate.add(2, -1);
        lastDate.set(5, 1);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(lastDate.getTime());
    }

    public static String getDateBeforeMonth(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar lastDate = (Calendar)c.clone();
        lastDate.add(2, months);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        return df.format(lastDate.getTime());
    }

    public static void main(String[] args) {
        String before = "2021-03-29";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date nowDate = null;
        try {
            nowDate = df.parse(before);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(DateUtils.getDateBeforeMonth(nowDate, -3));
    }

    public static Date getBeginDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        Date time = cal.getTime();
        return DateUtils.getDayStartTime(time);
    }

    public static Date getEndDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfWeek(date));
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getDayStartTime(Date date) {
        GregorianCalendar todayStart = new GregorianCalendar();
        todayStart.setTime(date);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getDayEndTime(Date date) {
        GregorianCalendar todayEnd = new GregorianCalendar();
        todayEnd.setTime(date);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Map<String, Long> getFirstdayLastdayMonth(Date date) {
        GregorianCalendar gcLast = (GregorianCalendar)Calendar.getInstance();
        gcLast.setTime(date);
        gcLast.set(5, 1);
        gcLast.set(11, 0);
        gcLast.set(12, 0);
        gcLast.set(13, 0);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("first", gcLast.getTime().getTime());
        map.put("last", calendar.getTime().getTime());
        return map;
    }

    public static Date transDate(String str) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parse = dateFormat.parse(str);
        return parse;
    }

    public static Long getZeroOfDayTime(Date time) {
        Calendar c = Calendar.getInstance();
        c.setTime(time);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime().getTime();
    }

    public static String getStrByDate(Date date, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String dateTime = sdf.format(date);
        return dateTime;
    }
}

