/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import com.chinaj.scheduling.common.util.CommonUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcelUtil<T> {
    public static final String EXCEl_FILE_2007 = "2007";
    public static final String EXCEL_FILE_2003 = "2003";

    public void exportExcel(String title, Collection<T> dataset, OutputStream out, String version) {
        if (CommonUtils.isEmpty(version) || EXCEL_FILE_2003.equals(version.trim())) {
            this.exportExcel2003(title, null, dataset, out, "yyyy-MM-dd HH:mm:ss");
        } else {
            this.exportExcel2007(title, null, dataset, out, "yyyy-MM-dd HH:mm:ss");
        }
    }

    public void exportExcel(String title, String[] headers, Collection<T> dataset, OutputStream out, String version) {
        if (CommonUtils.isEmpty(version) || EXCEL_FILE_2003.equals(version.trim())) {
            this.exportExcel2003(title, headers, dataset, out, "yyyy-MM-dd HH:mm:ss");
        } else {
            this.exportExcel2007(title, headers, dataset, out, "yyyy-MM-dd HH:mm:ss");
        }
    }

    public void exportExcel(String title, List<String[]> headers, List<String[]> mergeHeaders, Collection<T> dataset, OutputStream out, String version) {
        if (CommonUtils.isEmpty(version) || EXCEL_FILE_2003.equals(version.trim())) {
            this.exportExcel2003(title, headers, mergeHeaders, dataset, out, "yyyy-MM-dd HH:mm:ss");
        } else {
            this.exportExcel2007(title, headers, mergeHeaders, dataset, out, "yyyy-MM-dd HH:mm:ss");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel2007(String title, List<String[]> headers, List<String[]> mergeHeaders, Collection<T> dataset, OutputStream out, String pattern) {
        XSSFRow row;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.GRAY));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)11);
        style.setFont((Font)font);
        XSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(new XSSFColor(Color.WHITE));
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font2 = workbook.createFont();
        style2.setFont((Font)font2);
        int index = 0;
        if (headers != null && headers.size() > 0) {
            for (int h = 0; h < headers.size(); ++h) {
                String[] header = headers.get(h);
                row = sheet.createRow(h);
                for (int i = 0; i < header.length; ++i) {
                    XSSFCell cellHeader = row.createCell(i);
                    cellHeader.setCellStyle((CellStyle)style);
                    cellHeader.setCellValue((RichTextString)new XSSFRichTextString(header[i]));
                }
            }
            index = headers.size();
        }
        if (mergeHeaders != null && mergeHeaders.size() > 0) {
            for (String[] temp : mergeHeaders) {
                Integer startrow = Integer.parseInt(temp[0]);
                Integer overrow = Integer.parseInt(temp[1]);
                Integer startcol = Integer.parseInt(temp[2]);
                Integer overcol = Integer.parseInt(temp[3]);
                sheet.addMergedRegion(new CellRangeAddress(startrow.intValue(), overrow.intValue(), startcol.intValue(), overcol.intValue()));
            }
        }
        Iterator<T> it = dataset.iterator();
        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
        while (it.hasNext()) {
            XSSFCell cell;
            row = sheet.createRow(index);
            T t = it.next();
            if (t instanceof Object[]) {
                Object[] message = (Object[])t;
                for (int i = 0; i < message.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle((CellStyle)style2);
                    cell = this.getCell2007(cell, message[i], pattern, p);
                }
            } else {
                Field[] fields = t.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle((CellStyle)style2);
                    Field field = fields[i];
                    String fieldName = field.getName();
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        Object value = getMethod.invoke(t, new Object[0]);
                        cell = this.getCell2007(cell, value, pattern, p);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            ++index;
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel2003(String title, List<String[]> headers, List<String[]> mergeHeaders, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFRow row;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        font.setColor((short)Short.MAX_VALUE);
        font.setFontHeightInPoints((short)11);
        style.setFont(font);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE1.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font2 = workbook.createFont();
        style2.setFont(font2);
        int index = 0;
        if (headers != null && headers.size() > 0) {
            for (int h = 0; h < headers.size(); ++h) {
                String[] stringArray = headers.get(h);
                row = sheet.createRow(h);
                for (int i = 0; i < stringArray.length; ++i) {
                    HSSFCell cellHeader = row.createCell(i);
                    cellHeader.setCellStyle(style);
                    cellHeader.setCellValue((RichTextString)new HSSFRichTextString(stringArray[i]));
                }
            }
            index = headers.size();
        }
        sheet.addMergedRegion(CellRangeAddress.valueOf((String)"$A$2:$G$2"));
        if (mergeHeaders != null && mergeHeaders.size() > 0) {
            for (HSSFCell hSSFCell : mergeHeaders) {
                for (HSSFCell str : hSSFCell) {
                    String[] temp = str.split(",");
                    Integer startrow = Integer.parseInt(temp[0]);
                    Integer overrow = Integer.parseInt(temp[1]);
                    Integer startcol = Integer.parseInt(temp[2]);
                    Integer overcol = Integer.parseInt(temp[3]);
                    sheet.addMergedRegion(new CellRangeAddress(startrow.intValue(), overrow.intValue(), startcol.intValue(), overcol.intValue()));
                }
            }
        }
        Iterator<T> it = dataset.iterator();
        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
        while (it.hasNext()) {
            HSSFCell cell;
            row = sheet.createRow(index);
            T t = it.next();
            if (t instanceof Object[]) {
                Object[] message = (Object[])t;
                for (int i = 0; i < message.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle(style2);
                    cell = this.getCell2003(cell, message[i], pattern, p);
                }
            } else {
                Field[] fields = t.getClass().getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle(style2);
                    Field field = fields[i];
                    String fieldName = field.getName();
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    try {
                        Class<?> tCls = t.getClass();
                        Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                        Object value = getMethod.invoke(t, new Object[0]);
                        cell = this.getCell2003(cell, value, pattern, p);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            ++index;
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel2007(String title, String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        XSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(new XSSFColor(Color.gray));
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        font.setColor(new XSSFColor(Color.BLACK));
        font.setFontHeightInPoints((short)11);
        style.setFont((Font)font);
        XSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(new XSSFColor(Color.WHITE));
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont font2 = workbook.createFont();
        style2.setFont((Font)font2);
        XSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            XSSFCell cellHeader = row.createCell(i);
            cellHeader.setCellStyle((CellStyle)style);
            cellHeader.setCellValue((RichTextString)new XSSFRichTextString(headers[i]));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
        while (it.hasNext()) {
            XSSFCell cell;
            row = sheet.createRow(++index);
            T t = it.next();
            if (t instanceof Object[]) {
                Object[] message = (Object[])t;
                for (int i = 0; i < message.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle((CellStyle)style2);
                    cell = this.getCell2007(cell, message[i], pattern, p);
                }
                continue;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                cell = row.createCell(i);
                cell.setCellStyle((CellStyle)style2);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    cell = this.getCell2007(cell, value, pattern, p);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel2003(String title, String[] headers, Collection<T> dataset, OutputStream out, String pattern) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(title);
        sheet.setDefaultColumnWidth(20);
        HSSFCellStyle style = workbook.createCellStyle();
        style.setFillForegroundColor(IndexedColors.GREY_50_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        font.setFontName("\u5b8b\u4f53");
        font.setColor((short)Short.MAX_VALUE);
        font.setFontHeightInPoints((short)11);
        style.setFont(font);
        HSSFCellStyle style2 = workbook.createCellStyle();
        style2.setFillForegroundColor(IndexedColors.WHITE1.getIndex());
        style2.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style2.setBorderBottom(BorderStyle.THIN);
        style2.setBorderLeft(BorderStyle.THIN);
        style2.setBorderRight(BorderStyle.THIN);
        style2.setBorderTop(BorderStyle.THIN);
        style2.setAlignment(HorizontalAlignment.CENTER);
        style2.setVerticalAlignment(VerticalAlignment.CENTER);
        HSSFFont font2 = workbook.createFont();
        style2.setFont(font2);
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            HSSFCell cellHeader = row.createCell(i);
            cellHeader.setCellStyle(style);
            cellHeader.setCellValue((RichTextString)new HSSFRichTextString(headers[i]));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        Pattern p = Pattern.compile("^//d+(//.//d+)?$");
        while (it.hasNext()) {
            HSSFCell cell;
            row = sheet.createRow(++index);
            T t = it.next();
            if (t instanceof Object[]) {
                Object[] message = (Object[])t;
                for (int i = 0; i < message.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellStyle(style2);
                    cell = this.getCell2003(cell, message[i], pattern, p);
                }
                continue;
            }
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                cell = row.createCell(i);
                cell.setCellStyle(style2);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    cell = this.getCell2003(cell, value, pattern, p);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HSSFCell getCell2003(HSSFCell cell, Object value, String pattern, Pattern p) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String textValue = null;
        textValue = null;
        if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float) {
            textValue = String.valueOf((Float)value);
            cell.setCellValue(textValue);
        } else if (value instanceof Double) {
            textValue = String.valueOf((Double)value);
            cell.setCellValue(textValue);
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        }
        if (value instanceof Boolean) {
            textValue = "\u662f";
            if (!((Boolean)value).booleanValue()) {
                textValue = "\u5426";
            }
        } else if (value instanceof Date) {
            textValue = sdf.format((Date)value);
        } else if (value != null) {
            textValue = value.toString();
        }
        if (textValue != null) {
            Matcher matcher = p.matcher(textValue);
            if (matcher.matches()) {
                cell.setCellValue(Double.parseDouble(textValue));
            } else {
                HSSFRichTextString richString = new HSSFRichTextString(textValue);
                cell.setCellValue((RichTextString)richString);
            }
        }
        return cell;
    }

    private XSSFCell getCell2007(XSSFCell cell, Object value, String pattern, Pattern p) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String textValue = null;
        textValue = null;
        if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float) {
            textValue = String.valueOf((Float)value);
            cell.setCellValue(textValue);
        } else if (value instanceof Double) {
            textValue = String.valueOf((Double)value);
            cell.setCellValue(textValue);
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        }
        if (value instanceof Boolean) {
            textValue = "\u662f";
            if (!((Boolean)value).booleanValue()) {
                textValue = "\u5426";
            }
        } else if (value instanceof Date) {
            textValue = sdf.format((Date)value);
        } else if (value != null) {
            textValue = value.toString();
        }
        if (textValue != null) {
            Matcher matcher = p.matcher(textValue);
            if (matcher.matches()) {
                cell.setCellValue(Double.parseDouble(textValue));
            } else {
                XSSFRichTextString richString = new XSSFRichTextString(textValue);
                cell.setCellValue((RichTextString)richString);
            }
        }
        return cell;
    }
}

