/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ReadExcel {
    private int totalRows = 0;
    private int totalCells = 0;
    private String errorMsg;

    public int getTotalRows() {
        return this.totalRows;
    }

    public int getTotalCells() {
        return this.totalCells;
    }

    public String getErrorInfo() {
        return this.errorMsg;
    }

    public List<Map<String, Object>> getExcelInfo(MultipartFile mFile) {
        String fileName = mFile.getOriginalFilename();
        try {
            if (!this.validateExcel(fileName)) {
                return null;
            }
            boolean isExcel2003 = true;
            if (ReadExcel.isExcel2007(fileName)) {
                isExcel2003 = false;
            }
            return this.createExcel(mFile.getInputStream(), isExcel2003);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Map<String, Object>> createExcel(InputStream is, boolean isExcel2003) {
        try {
            Object wb = null;
            wb = isExcel2003 ? new HSSFWorkbook(is) : new XSSFWorkbook(is);
            return this.readExcelValue((Workbook)wb);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<Map<String, Object>> readExcelValue(Workbook wb) {
        Sheet sheet = wb.getSheetAt(0);
        this.totalRows = sheet.getPhysicalNumberOfRows();
        if (this.totalRows > 1 && sheet.getRow(0) != null) {
            this.totalCells = sheet.getRow(0).getPhysicalNumberOfCells();
        }
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>();
        for (int r = 5; r < this.totalRows; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("enable", "1");
            map.put("error", "error: ");
            map.put("totalRows", this.totalRows);
            for (int c = 0; c < this.totalCells; ++c) {
                Cell cell = row.getCell(c);
                if (c == 0) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u533a\u57df\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u533a\u57df\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    map.put("region", cell.getStringCellValue());
                    continue;
                }
                if (c == 1) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u6d41\u7a0b\u540d\u79f0\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u6d41\u7a0b\u540d\u79f0\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    map.put("procName", cell.getStringCellValue());
                    continue;
                }
                if (c == 2) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    map.put("taskName", cell.getStringCellValue());
                    continue;
                }
                if (c == 3) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a\uff1b");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5546\u54c1\u5206\u7c7b\u4e3a\u7a7a\uff1b");
                        continue;
                    }
                    map.put("goodsType", cell.getStringCellValue());
                    continue;
                }
                if (c == 4) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u914d\u7f6e\u65b9\u5f0f\u4e3a\u7a7a\uff1b");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u914d\u7f6e\u65b9\u5f0f\u4e3a\u7a7a\uff1b");
                        continue;
                    }
                    map.put("staffConfigType", cell.getStringCellValue());
                    continue;
                }
                if (c == 5) {
                    if (cell == null) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    System.out.println("cell.getStringCellValue()=" + cell.getStringCellValue());
                    if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                        map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u4e3a\u7a7a\uff1b");
                        map.put("enable", "0");
                        continue;
                    }
                    System.out.println("\u6b63\u5e38\u5904\u7406\u4eba\uff1a" + cell.getStringCellValue());
                    map.put("staffId", cell.getStringCellValue());
                    continue;
                }
                if (c != 6) continue;
                if (cell == null) {
                    map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u6307\u5b9a\u89c4\u5219\u4e3a\u7a7a\uff1b");
                    continue;
                }
                cell.setCellType(CellType.STRING);
                if (null == cell.getStringCellValue() || "".equals(cell.getStringCellValue())) {
                    map.put("error", map.get("error").toString() + "\u7b2c" + (r + 1) + "\u884c\u5904\u7406\u4eba\u6307\u5b9a\u89c4\u5219\u4e3a\u7a7a\uff1b");
                    continue;
                }
                map.put("staffDefineRule", cell.getStringCellValue());
            }
            userList.add(map);
        }
        return userList;
    }

    public boolean validateExcel(String filePath) {
        if (filePath == null || !ReadExcel.isExcel2003(filePath) && !ReadExcel.isExcel2007(filePath)) {
            this.errorMsg = "\u6587\u4ef6\u540d\u4e0d\u662fexcel\u683c\u5f0f";
            return false;
        }
        return true;
    }

    public static boolean isExcel2003(String filePath) {
        return filePath.matches("^.+\\.(?i)(xls)$");
    }

    public static boolean isExcel2007(String filePath) {
        return filePath.matches("^.+\\.(?i)(xlsx)$");
    }
}

