/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.scheduling.common.util;

import java.util.HashMap;
import java.util.Map;

public class ThreadLocalUtil {
    private static final ThreadLocal CONTEXT = new ThreadLocal();

    private ThreadLocalUtil() {
    }

    private static Map getLocalMap(String key, boolean isCreate) {
        HashMap map = (HashMap)CONTEXT.get();
        if (map == null && isCreate) {
            map = new HashMap();
            CONTEXT.set(map);
        }
        return map;
    }

    public static Object get(String key) {
        Map map = ThreadLocalUtil.getLocalMap(key, false);
        return map != null ? map.get(key) : null;
    }

    public static void set(String key, Object obj) {
        Map map = ThreadLocalUtil.getLocalMap(key, true);
        map.put(key, obj);
    }

    public static void remove(String key) {
        Map map = ThreadLocalUtil.getLocalMap(key, false);
        if (map != null) {
            map.remove(key);
        }
    }

    public static void removeAll() {
        Map map = (Map)CONTEXT.get();
        if (map != null) {
            map.clear();
            CONTEXT.remove();
        }
    }
}

