/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;

public class FactorExpressionUtil {
    public static final String AND = "&";
    public static final String NOT = "!";
    private static final HashMap<String, Integer> ISP_MAP = new HashMap();
    private static final HashMap<String, Integer> ICP_MAP = new HashMap();
    private static final String OR = "|";
    private static final String LEFT_BRACKETS = "(";
    private static final String RIGHT_BRACKETS = ")";
    private static final String END_TAG = "#";

    public static List<String> dealMiddleExpression(String middleExpression) {
        List<String> values = FactorExpressionUtil.splitExpression(middleExpression);
        ArrayList<String> list = new ArrayList<String>();
        ArrayDeque<String> stackDeque = new ArrayDeque<String>();
        stackDeque.push(END_TAG);
        for (String value : values) {
            if (FactorExpressionUtil.isOperator(value) || END_TAG.equals(value)) {
                FactorExpressionUtil.stackRule(list, stackDeque, value);
                continue;
            }
            list.add(value);
        }
        return list;
    }

    public static List<String> splitExpression(String expression) {
        ArrayList<String> splitExpression = new ArrayList<String>();
        int expressionIndex = 0;
        StringBuilder container = new StringBuilder();
        while (expressionIndex < expression.length()) {
            String value;
            if (FactorExpressionUtil.isOperator(value = String.valueOf(expression.charAt(expressionIndex++)))) {
                if (container.length() > 0) {
                    splitExpression.add(container.toString());
                    container.delete(0, container.length());
                }
                splitExpression.add(value);
                continue;
            }
            container.append(value);
        }
        if (container.length() > 0) {
            splitExpression.add(container.toString());
        }
        splitExpression.add(END_TAG);
        return splitExpression;
    }

    public static boolean isOperatorExceptNot(String value) {
        return AND.equals(value) || OR.equals(value) || LEFT_BRACKETS.equals(value) || RIGHT_BRACKETS.equals(value);
    }

    public static boolean isOperator(String value) {
        return FactorExpressionUtil.isOperatorExceptNot(value) || NOT.equals(value);
    }

    public static void stackRule(List<String> list, Deque<String> stackDeque, String value) {
        if (ISP_MAP.get(stackDeque.peek()) < ICP_MAP.get(value)) {
            stackDeque.push(value);
        } else if (ISP_MAP.get(stackDeque.peek()) > ICP_MAP.get(value)) {
            list.add(stackDeque.pop());
            FactorExpressionUtil.stackRule(list, stackDeque, value);
        } else {
            stackDeque.pop();
        }
    }

    static {
        ISP_MAP.put(END_TAG, 0);
        ISP_MAP.put(LEFT_BRACKETS, 1);
        ISP_MAP.put(RIGHT_BRACKETS, 6);
        ISP_MAP.put(NOT, 5);
        ISP_MAP.put(AND, 3);
        ISP_MAP.put(OR, 3);
        ICP_MAP.put(END_TAG, 0);
        ICP_MAP.put(LEFT_BRACKETS, 6);
        ICP_MAP.put(RIGHT_BRACKETS, 1);
        ICP_MAP.put(AND, 2);
        ICP_MAP.put(OR, 2);
        ICP_MAP.put(NOT, 4);
    }
}

