/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.controller.BaseController;
import com.chinaj.common.core.domain.AjaxResult;
import com.chinaj.common.core.page.TableDataInfo;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.busi.IFormAtomicCompService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/atomic"})
public class FormAtomicCompController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FormAtomicCompController.class);
    @Autowired
    IFormAtomicCompService formAtomicCompService;

    @PostMapping(value={"/list"})
    @ResponseBody
    public AjaxResult list(@RequestBody String data, HttpServletRequest request) {
        try {
            JSONArray array = this.formAtomicCompService.list(data);
            return AjaxResult.success((Object)array);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u539f\u5b50\u7ec4\u4ef6\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u539f\u5b50\u7ec4\u4ef6\u6570\u636e\u5931\u8d25");
        }
    }

    @PostMapping(value={"/listAtomicComps"})
    @ResponseBody
    public TableDataInfo listAtomicComps(@RequestBody String data, HttpServletRequest request) {
        this.startPage();
        JSONArray array = this.formAtomicCompService.listAtomicComps(data);
        List list = JSONArray.parseArray((String)array.toJSONString(), JSONObject.class);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/getAtomicComp/{id}"})
    @ResponseBody
    public AjaxResult getAtomicComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u539f\u5b50\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject ruleConfig = this.formAtomicCompService.getAtomicComp(id);
            return AjaxResult.success((Object)ruleConfig);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25");
        }
    }

    @PostMapping(value={"/saveAtomicComp"})
    @ResponseBody
    public AjaxResult saveAtomicComp(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formAtomicCompService.saveAtomicComp(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fdd\u5b58\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fdd\u5b58\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
    }

    @PostMapping(value={"/updateAtomicComp"})
    @ResponseBody
    public AjaxResult updateAtomicComp(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fee\u6539\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formAtomicCompService.updateAtomicComp(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fee\u6539\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fee\u6539\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
    }

    @PostMapping(value={"/initAtomicComp"})
    @ResponseBody
    public AjaxResult initAtomicComp(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formAtomicCompService.initAtomicComp(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u521d\u59cb\u5316\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u521d\u59cb\u5316\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
    }

    @GetMapping(value={"/deleteAtomicComp/{id}"})
    @ResponseBody
    public AjaxResult deleteAtomicComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u539f\u5b50\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject ruleConfig = this.formAtomicCompService.deleteAtomicComp(id);
            return AjaxResult.success((Object)ruleConfig);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25");
        }
    }

    @GetMapping(value={"/deployAtomicComp/{id}"})
    @ResponseBody
    public AjaxResult deployAtomicComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u539f\u5b50\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = this.formAtomicCompService.deployAtomicComp(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u53d1\u5e03\u539f\u5b50\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u539f\u5b50\u7ec4\u4ef6\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.success((String)"\u53d1\u5e03\u539f\u5b50\u7ec4\u4ef6\u5931\u8d25");
    }
}

