/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.controller.BaseController;
import com.chinaj.common.core.domain.AjaxResult;
import com.chinaj.common.core.page.TableDataInfo;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.busi.IFormBusinessCompService;
import com.chinaj.engine.form.api.busi.IFormSaveBusinessCompService;
import com.chinaj.engine.form.api.busi.IFormUpdateBusinessCompService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/business"})
public class FormBusinessCompController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FormBusinessCompController.class);
    @Autowired
    IFormBusinessCompService formBusinessCompService;
    @Autowired
    IFormSaveBusinessCompService formSaveBusinessCompService;
    @Autowired
    IFormUpdateBusinessCompService formUpdateBusinessCompService;

    @PostMapping(value={"/list"})
    @ResponseBody
    public AjaxResult list(@RequestBody String data, HttpServletRequest request) {
        try {
            JSONArray array = this.formBusinessCompService.list(data);
            return AjaxResult.success((Object)array);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u4e1a\u52a1\u7ec4\u4ef6\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u4e1a\u52a1\u7ec4\u4ef6\u6570\u636e\u5931\u8d25");
        }
    }

    @PostMapping(value={"/listBusinessComps"})
    @ResponseBody
    public TableDataInfo listBusinessComps(@RequestBody String data, HttpServletRequest request) {
        this.startPage();
        JSONArray array = this.formBusinessCompService.listBusinessComps(data);
        List list = JSONArray.parseArray((String)array.toJSONString(), JSONObject.class);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/initConfig/{id}"})
    @ResponseBody
    public AjaxResult initConfig(@RequestBody String data) {
        try {
            JSONObject ruleConfig = new JSONObject();
            return AjaxResult.success((Object)ruleConfig);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getBusinessComp/{id}"})
    @ResponseBody
    public AjaxResult getBusinessComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u4e1a\u52a1\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject businessComp = this.formBusinessCompService.getBusinessComp(id);
            return AjaxResult.success((Object)businessComp);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25");
        }
    }

    @PostMapping(value={"/saveBusinessComp"})
    @ResponseBody
    public AjaxResult saveBusinessComp(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formSaveBusinessCompService.saveBusinessComp(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fdd\u5b58\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fdd\u5b58\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
    }

    @PostMapping(value={"/updateBusinessComp"})
    @ResponseBody
    public AjaxResult updateBusinessComp(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fee\u6539\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formUpdateBusinessCompService.updateBusinessComp(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fee\u6539\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fee\u6539\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u5931\u8d25");
    }

    @GetMapping(value={"/copyBusinessComp/{id}"})
    @ResponseBody
    public AjaxResult copyBusinessComp(@PathVariable(value="id") Long id, HttpServletRequest request) {
        boolean status = false;
        try {
            JSONObject jsonObject = this.formBusinessCompService.copyBusinessComp(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fee\u6539\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25:{}{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u590d\u5236\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25',lcProcessId:'0'");
    }

    @GetMapping(value={"/deployBusinessComp/{id}"})
    @ResponseBody
    public AjaxResult deployBusinessComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u4e1a\u52a1\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = this.formBusinessCompService.deployBusinessComp(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u53d1\u5e03\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.success((String)"\u53d1\u5e03\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25");
    }

    @GetMapping(value={"/deleteBusinessComp/{id}"})
    @ResponseBody
    public AjaxResult deleteBusinessComp(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u4e1a\u52a1\u7ec4\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = this.formBusinessCompService.deleteBusinessComp(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u5220\u9664\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.success((String)"\u5220\u9664\u4e1a\u52a1\u7ec4\u4ef6\u5931\u8d25");
    }

    @GetMapping(value={"/getBusinessCompType"})
    @ResponseBody
    public AjaxResult getBusinessCompType() {
        return AjaxResult.success((Object)this.formBusinessCompService.getBusinessCompType());
    }
}

