/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.controller.BaseController;
import com.chinaj.common.core.domain.AjaxResult;
import com.chinaj.common.core.page.TableDataInfo;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.busi.IFormSceneBusiService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form/scene"})
public class FormSceneController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(FormSceneController.class);
    @Autowired
    private IFormSceneBusiService formSceneBusiService;

    @PostMapping(value={"/listScenes"})
    @ResponseBody
    public TableDataInfo listScenes(@RequestBody String data, HttpServletRequest request) {
        this.startPage();
        JSONArray array = this.formSceneBusiService.listScenes(data);
        List list = JSONArray.parseArray((String)array.toJSONString(), JSONObject.class);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/getScene/{id}"})
    @ResponseBody
    public AjaxResult getScene(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u573a\u666f\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject pageComp = this.formSceneBusiService.getScene(id);
            return AjaxResult.success((Object)pageComp);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
            return AjaxResult.error((String)"\u83b7\u53d6\u89c4\u5219\u6570\u636e\u5931\u8d25");
        }
    }

    @PostMapping(value={"/saveScene"})
    @ResponseBody
    public AjaxResult saveScene(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u573a\u666f\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formSceneBusiService.saveScene(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fdd\u5b58\u573a\u666f\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u573a\u666f\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fdd\u5b58\u573a\u666f\u914d\u7f6e\u5931\u8d25");
    }

    @PostMapping(value={"/updateScene"})
    @ResponseBody
    public AjaxResult updateScene(@RequestBody String data) {
        if (StringUtils.isEmpty((String)data)) {
            return AjaxResult.error((String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u4fee\u6539\u573a\u666f\u914d\u7f6e\u5931\u8d25");
        }
        try {
            JSONObject jsonObject = this.formSceneBusiService.updateScene(data);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u4fee\u6539\u573a\u666f\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u573a\u666f\u914d\u7f6e\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u4fee\u6539\u573a\u666f\u914d\u7f6e\u5931\u8d25");
    }

    @GetMapping(value={"/copyScene/{id}"})
    @ResponseBody
    public AjaxResult copyScene(@PathVariable(value="id") Long id, HttpServletRequest request) {
        boolean status = false;
        try {
            JSONObject jsonObject = this.formSceneBusiService.copyScene(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u590d\u5236\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u590d\u5236\u573a\u666f\u5931\u8d25:{}{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.error((String)"\u590d\u5236\u573a\u666f\u5931\u8d25");
    }

    @GetMapping(value={"/deployScene/{id}"})
    @ResponseBody
    public AjaxResult deployScene(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u573a\u666f\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = this.formSceneBusiService.deployScene(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u53d1\u5e03\u4e1a\u52a1\u7ec4\u4ef6\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u573a\u666f\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.success((String)"\u53d1\u5e03\u573a\u666f\u5931\u8d25");
    }

    @GetMapping(value={"/deleteScene/{id}"})
    @ResponseBody
    public AjaxResult deleteScene(@PathVariable(value="id") Long id) {
        if (StringUtils.isEmpty((Object)id)) {
            return AjaxResult.success((String)"\u573a\u666f\u6807\u8bc6\u4e3a\u7a7a");
        }
        try {
            JSONObject jsonObject = this.formSceneBusiService.deleteScene(id);
            int varStatus = jsonObject.getIntValue("status");
            if (varStatus > 0) {
                return AjaxResult.success((String)"\u5220\u9664\u573a\u666f\u914d\u7f6e\u6210\u529f");
            }
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u573a\u666f\u5931\u8d25", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return AjaxResult.success((String)"\u5220\u9664\u573a\u666f\u5931\u8d25");
    }
}

