/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.processor.build;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.common.utils.spring.SpringUtils;
import com.chinaj.core.common.RedisUtil;
import com.chinaj.engine.form.api.IFormCommonService;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormModulePropRelService;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.domain.FormModule;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import com.chinaj.engine.form.processor.IBuildModuleClassProcessor;
import com.chinaj.engine.form.processor.IBuildPathDependClassProcessor;
import com.chinaj.engine.form.processor.IBuildValueDependClassProcessor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseModuleProcessor
implements IBuildModuleClassProcessor {
    @Autowired
    protected IFormCommonService formCommonService;
    @Autowired
    IFormFactorExpressionService factorExpressionService;
    @Autowired
    private IFormModuleService moduleService;
    @Autowired
    private IFormModulePropRelService modulePropService;
    @Autowired
    private IFormTemplateModuleRelService templateModuleService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public void build(JSONArray components, FormTemplateModuleRel templateModule, JSONObject paramJson) {
        this.moduleList(components, templateModule, paramJson);
    }

    protected void moduleList(JSONArray components, FormTemplateModuleRel templateModuleRel, JSONObject paramJson) {
        JSONObject componentJson = new JSONObject();
        this.dealBaseModule(componentJson, templateModuleRel);
        List<FormModulePropRel> moduleElements = JSON.parseArray((String)this.redisUtil.getRedis("FormRedis:FormModulePropRel" + templateModuleRel.getModuleId()), FormModulePropRel.class);
        if (moduleElements == null || moduleElements.isEmpty()) {
            FormModulePropRel moduleElementQuery = new FormModulePropRel();
            moduleElementQuery.setModuleId(templateModuleRel.getModuleId());
            moduleElements = this.modulePropService.selectFormModulePropRelList(moduleElementQuery);
            this.redisUtil.setRedis("FormRedis:FormModulePropRel" + templateModuleRel.getModuleId(), JSON.toJSONString(moduleElements), 1L, TimeUnit.HOURS);
        }
        this.dealModuleElements(componentJson, moduleElements, paramJson);
        FormTemplateModuleRel formTemplateModuleRel = new FormTemplateModuleRel();
        Long moduleId = templateModuleRel.getModuleId();
        formTemplateModuleRel.setParentModule(StringUtils.killNull((Object)moduleId));
        Long tmplId = templateModuleRel.getTmplId();
        formTemplateModuleRel.setTmplId(tmplId);
        List<FormTemplateModuleRel> list = this.templateModuleService.selectFormTemplateModuleRelList(formTemplateModuleRel);
        if (StringUtils.isNotEmpty(list)) {
            JSONArray array = new JSONArray();
            this.dealSubModule(array, paramJson, list);
            JSONArray elements = componentJson.getJSONArray("elements");
            if (elements == null) {
                elements = new JSONArray();
            }
            elements.addAll((Collection)array);
            componentJson.put("elements", (Object)elements);
        }
        if (componentJson.get((Object)"elements") == null) {
            componentJson.put("elements", (Object)new JSONArray());
        }
        components.add((Object)componentJson);
    }

    protected void dealBaseModule(JSONObject componentJson, FormTemplateModuleRel templateModuleRel) {
        Long moduleId = templateModuleRel.getModuleId();
        FormModule formModule = this.moduleService.selectFormModuleById(moduleId);
        componentJson.put("componentCode", (Object)formModule.getModuleCode());
        componentJson.put("componentName", (Object)formModule.getModuleName());
        componentJson.put("receiptRelCode", (Object)templateModuleRel.getReceiptRelCode());
        componentJson.put("receiptRelUrl", (Object)templateModuleRel.getReceiptRelUrl());
        componentJson.put("topLabel", (Object)templateModuleRel.getModuleName());
        componentJson.put("viewCode", (Object)templateModuleRel.getViewCode());
        componentJson.put("id", (Object)moduleId);
        componentJson.put("parentId", (Object)templateModuleRel.getParentModule());
        componentJson.put("sequence", (Object)templateModuleRel.getSequence());
    }

    protected void dealModuleElements(JSONObject componentJson, List<FormModulePropRel> moduleElements, JSONObject paramJson) {
        if (moduleElements != null && !moduleElements.isEmpty()) {
            JSONArray elementArray = new JSONArray();
            for (FormModulePropRel moduleElement : moduleElements) {
                Long id;
                String elementFactors = moduleElement.getFactors();
                if (!this.factorExpressionService.isShowCurrentElement(elementFactors, paramJson, id = moduleElement.getId(), "prop")) continue;
                this.dealModuleElement(elementArray, moduleElement, paramJson);
            }
            componentJson.put("elements", (Object)elementArray);
        }
    }

    protected abstract void dealModuleElement(JSONArray var1, FormModulePropRel var2, JSONObject var3);

    protected void dealSubModule(JSONArray components, JSONObject paramJson, List<FormTemplateModuleRel> list) {
        for (FormTemplateModuleRel templateModule : list) {
            Long id;
            String moduleFactors = templateModule.getFactors();
            if (!this.factorExpressionService.isShowCurrentElement(moduleFactors, paramJson, id = templateModule.getId(), "module")) continue;
            String receiptRelCode = templateModule.getReceiptRelCode();
            if (StringUtils.isNotEmpty((String)receiptRelCode)) {
                paramJson.put("pathParams", (Object)receiptRelCode);
            }
            IBuildModuleClassProcessor processor = (IBuildModuleClassProcessor)SpringUtils.getBean((String)templateModule.getClassName());
            processor.build(components, templateModule, paramJson);
            paramJson.remove((Object)"pathParams");
        }
    }

    protected void dealRwTag(JSONObject element, String rwTag) {
        if (StringUtils.isNotEmpty((String)rwTag)) {
            String[] split = rwTag.split("&");
            String type = split[0];
            if ("02".equals(type) || "03".equals(type)) {
                element.put("disabled", (Object)true);
            } else if ("05".equals(type)) {
                element.put("isShow", (Object)false);
            } else if ("06".equals(type)) {
                element.put("disType", (Object)"text");
            }
            if (split.length > 1) {
                if ("10".equals(split[1])) {
                    element.put("isBtnBarEl", (Object)true);
                } else if ("11".equals(split[1])) {
                    element.put("isBtnBarEl", (Object)false);
                }
            }
        }
    }

    protected String getRelOrConfigProp(String propRel, String propConfig) {
        return StringUtils.isNotEmpty((String)propRel) ? propRel : propConfig;
    }

    protected void getElementValue(JSONObject dataJson, FormPropConfig element, JSONObject paramJson) {
        String valueDependClass;
        String dependClass = element.getDependClass();
        if (StringUtils.isNotEmpty((String)dependClass) && StringUtils.isNotEmpty((String)element.getDependField())) {
            IBuildPathDependClassProcessor processor = (IBuildPathDependClassProcessor)SpringUtils.getBean((String)dependClass);
            processor.build(element, paramJson, dataJson);
        }
        if (StringUtils.isNotEmpty((String)(valueDependClass = element.getValueDependClass())) && StringUtils.isNotEmpty((String)element.getValueDependField())) {
            IBuildValueDependClassProcessor valueProcessor = (IBuildValueDependClassProcessor)SpringUtils.getBean((String)valueDependClass);
            valueProcessor.build(element.getValueDependField(), dataJson);
        }
    }
}

