/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.processor.build.format;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.domain.AjaxResult;
import com.chinaj.common.core.domain.entity.SysDictData;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.common.DicUtil;
import com.chinaj.engine.form.processor.build.BaseFormatProcessor;
import com.chinaj.sys.system.service.impl.DictServiceImpl;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SystemDictDataProcessor
extends BaseFormatProcessor {
    private static final String DICT_CODE = "dictCode";
    private static final String PARENT_CODE = "parentCode";
    private static final String DICT_LABEL = "dictLabel";
    private static final String DICT_VALUE = "dictValue";
    @Autowired
    private DictServiceImpl dictService;

    @Override
    public void build(String dictType, JSONObject dataJson) {
        AjaxResult dictResult;
        JSONArray dictDataArray = new JSONArray();
        if (StringUtils.isNotEmpty((String)dictType) && Objects.equals((dictResult = this.dictService.getDictDataByType(dictType)).get((Object)"code"), 200)) {
            List array = (List)dictResult.get((Object)"data");
            for (int i = 0; i < array.size(); ++i) {
                SysDictData dict = (SysDictData)array.get(i);
                JSONObject dictData = new JSONObject();
                dictData.put(DICT_CODE, (Object)dict.getDictCode());
                dictData.put(PARENT_CODE, (Object)dict.getParentCode());
                dictData.put("label", (Object)dict.getDictLabel());
                dictData.put("value", (Object)dict.getDictValue());
                dictDataArray.add((Object)dictData);
            }
            dictDataArray = DicUtil.dealTreeInfo(dictDataArray, DICT_CODE, PARENT_CODE);
        }
        dataJson.put("dictData", (Object)dictDataArray);
    }
}

