/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.processor.build.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.core.common.RedisUtil;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.processor.build.BaseModuleProcessor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonModuleProcessor
extends BaseModuleProcessor {
    @Autowired
    private IFormPropConfigService propConfigService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    protected void dealModuleElement(JSONArray elementArray, FormModulePropRel moduleElement, JSONObject paramJson) {
        FormPropConfig element = (FormPropConfig)((Object)JSON.parseObject((String)this.redisUtil.getRedis("FormRedis:FormPropConfig" + moduleElement.getPropId()), FormPropConfig.class));
        if (element == null) {
            element = this.propConfigService.selectFormPropConfigById(moduleElement.getPropId());
            this.redisUtil.setRedis("FormRedis:FormPropConfig" + moduleElement.getPropId(), JSON.toJSONString((Object)((Object)element)), 1L, TimeUnit.HOURS);
        }
        JSONObject elementJson = new JSONObject();
        elementJson.put("elType", (Object)super.getRelOrConfigProp(moduleElement.getHtmlType(), element.getHtmlType()));
        elementJson.put("code", (Object)element.getPropCode());
        elementJson.put("col", (Object)Integer.parseInt(moduleElement.getLayout()));
        elementJson.put("label", (Object)element.getPropName());
        elementJson.put("htmlDealCode", (Object)element.getHtmlDealCode());
        elementJson.put("rules", (Object)this.getCheckRules(element.getCheckRule(), moduleElement.getCheckRule()));
        elementJson.put("relevantData", (Object)JSON.parseObject((String)moduleElement.getLinkageRule()));
        super.dealRwTag(elementJson, this.getRelOrConfigProp(moduleElement.getRwTag(), moduleElement.getRwTag()));
        JSONObject dataJson = new JSONObject();
        super.getElementValue(dataJson, element, paramJson);
        Object obj = dataJson.get((Object)"data");
        if (!StringUtils.isEmpty((Object)obj)) {
            if (obj instanceof String) {
                elementJson.put("realValue", (Object)dataJson.getString("data"));
            } else if (obj instanceof JSONObject) {
                elementJson.put("realValue", (Object)dataJson.getJSONObject("data"));
            }
        }
        elementJson.put("dictData", (Object)dataJson.getJSONArray("dictData"));
        elementJson.put("defaultVal", (Object)StringUtils.defaultString((String)dataJson.getString("defaultVal"), (String)element.getDefaultValue()));
        elementJson.put("wrapper", (Object)element.getLayOutType());
        elementJson.put("sequence", (Object)moduleElement.getSequence());
        elementArray.add((Object)elementJson);
    }

    private JSONArray getCheckRules(String formPropConfigRule, String formModulePropRelRule) {
        JSONArray propRelRule = JSON.parseArray((String)formModulePropRelRule);
        JSONArray propConfigRule = JSON.parseArray((String)formPropConfigRule);
        if (StringUtils.isEmpty((Collection)propRelRule)) {
            propRelRule = new JSONArray();
        }
        if (StringUtils.isEmpty((Collection)propConfigRule)) {
            propConfigRule = new JSONArray();
        }
        propRelRule.addAll((Collection)propConfigRule);
        return propRelRule;
    }
}

