/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.processor.build.module;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.common.utils.spring.SpringUtils;
import com.chinaj.engine.form.api.IFormCommonService;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormModulePropRelService;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.domain.FormModule;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import com.chinaj.engine.form.processor.IBuildModuleClassProcessor;
import com.chinaj.engine.form.processor.IBuildPathDependClassProcessor;
import com.chinaj.engine.form.processor.IBuildValueDependClassProcessor;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoodsPreviewProcessor
implements IBuildModuleClassProcessor {
    @Autowired
    protected IFormCommonService formCommonService;
    @Autowired
    IFormFactorExpressionService factorExpressionService;
    @Autowired
    private IFormModuleService moduleService;
    @Autowired
    private IFormModulePropRelService modulePropService;
    @Autowired
    private IFormTemplateModuleRelService templateModuleService;
    @Autowired
    private IFormPropConfigService propConfigService;

    @Override
    public void build(JSONArray components, FormTemplateModuleRel templateModule, JSONObject paramJson) {
        this.moduleList(components, templateModule, paramJson);
    }

    protected void moduleList(JSONArray components, FormTemplateModuleRel templateModuleRel, JSONObject paramJson) {
        JSONObject componentJson = new JSONObject();
        this.dealBaseModule(componentJson, templateModuleRel);
        FormModulePropRel moduleElementQuery = new FormModulePropRel();
        moduleElementQuery.setModuleId(templateModuleRel.getModuleId());
        List<FormModulePropRel> moduleElements = this.modulePropService.selectFormModulePropRelList(moduleElementQuery);
        this.dealModuleElements(componentJson, moduleElements, paramJson);
        FormTemplateModuleRel formTemplateModuleRel = new FormTemplateModuleRel();
        Long moduleId = templateModuleRel.getModuleId();
        formTemplateModuleRel.setParentModule(StringUtils.killNull((Object)moduleId));
        Long tmplId = templateModuleRel.getTmplId();
        formTemplateModuleRel.setTmplId(tmplId);
        List<FormTemplateModuleRel> list = this.templateModuleService.selectFormTemplateModuleRelList(formTemplateModuleRel);
        JSONArray elements = componentJson.getJSONArray("elements");
        if (elements == null) {
            elements = new JSONArray();
        }
        if (StringUtils.isNotEmpty(list)) {
            JSONArray array = new JSONArray();
            if (StringUtils.isBlank((CharSequence)templateModuleRel.getReceiptRelCode())) {
                this.dealSubModule(array, paramJson, list);
                elements.addAll((Collection)array);
                componentJson.put("elements", (Object)elements);
            } else {
                Object obj = JSONPath.eval((Object)paramJson, (String)templateModuleRel.getReceiptRelCode());
                if (obj != null) {
                    JSONArray goodJsonArray = JSONArray.parseArray((String)obj.toString());
                    int i = 1;
                    for (Object good2 : goodJsonArray) {
                        JSONArray jsonArray;
                        JSONObject jsonObject = JSONObject.parseObject((String)good2.toString());
                        JSONObject simpleGoodsInfo = jsonObject.getJSONObject("simpleGoodsInfo");
                        JSONObject newGoodsInfo = new JSONObject();
                        newGoodsInfo.put("componentCode", (Object)jsonObject.getString("singleKey"));
                        newGoodsInfo.put("componentName", (Object)simpleGoodsInfo.getString("goodsName"));
                        newGoodsInfo.put("receiptRelCode", (Object)templateModuleRel.getReceiptRelCode());
                        newGoodsInfo.put("receiptRelUrl", (Object)templateModuleRel.getReceiptRelUrl());
                        newGoodsInfo.put("topLabel", (Object)simpleGoodsInfo.getString("goodsName"));
                        newGoodsInfo.put("viewCode", (Object)"productCommon");
                        newGoodsInfo.put("id", (Object)simpleGoodsInfo.getString("goodsSku"));
                        newGoodsInfo.put("parentId", (Object)templateModuleRel.getParentModule());
                        newGoodsInfo.put("sequence", (Object)i);
                        JSONArray goodElements = new JSONArray();
                        if (StringUtils.isNotEmpty(list)) {
                            JSONArray goodsArray = new JSONArray();
                            this.dealSubModule(goodsArray, paramJson, list);
                            if (goodElements == null) {
                                goodElements = new JSONArray();
                            }
                            goodElements.addAll((Collection)goodsArray);
                            newGoodsInfo.put("elements", (Object)goodElements);
                        }
                        if (newGoodsInfo.get((Object)"elements") == null) {
                            newGoodsInfo.put("elements", (Object)new JSONArray());
                        }
                        if (!(jsonArray = newGoodsInfo.getJSONArray("elements")).isEmpty()) {
                            elements.add((Object)newGoodsInfo);
                        }
                        ++i;
                    }
                    componentJson.put("elements", (Object)elements);
                }
            }
        }
        if (componentJson.get((Object)"elements") == null) {
            componentJson.put("elements", (Object)new JSONArray());
        }
        components.add((Object)componentJson);
    }

    protected void dealBaseModule(JSONObject componentJson, FormTemplateModuleRel templateModuleRel) {
        Long moduleId = templateModuleRel.getModuleId();
        FormModule formModule = this.moduleService.selectFormModuleById(moduleId);
        componentJson.put("componentCode", (Object)formModule.getModuleCode());
        componentJson.put("componentName", (Object)formModule.getModuleName());
        componentJson.put("receiptRelCode", (Object)templateModuleRel.getReceiptRelCode());
        componentJson.put("receiptRelUrl", (Object)templateModuleRel.getReceiptRelUrl());
        componentJson.put("topLabel", (Object)templateModuleRel.getModuleName());
        componentJson.put("viewCode", (Object)templateModuleRel.getViewCode());
        componentJson.put("id", (Object)moduleId);
        componentJson.put("parentId", (Object)templateModuleRel.getParentModule());
        componentJson.put("sequence", (Object)templateModuleRel.getSequence());
    }

    protected void dealModuleElements(JSONObject componentJson, List<FormModulePropRel> moduleElements, JSONObject paramJson) {
        if (moduleElements != null && !moduleElements.isEmpty()) {
            JSONArray elementArray = new JSONArray();
            for (FormModulePropRel moduleElement : moduleElements) {
                Long id;
                String elementFactors = moduleElement.getFactors();
                if (!this.factorExpressionService.isShowCurrentElement(elementFactors, paramJson, id = moduleElement.getId(), "prop")) continue;
                this.dealModuleElement(elementArray, moduleElement, paramJson);
            }
            componentJson.put("elements", (Object)elementArray);
        }
    }

    protected void dealModuleElement(JSONArray elementArray, FormModulePropRel moduleElement, JSONObject paramJson) {
        FormPropConfig element = this.propConfigService.selectFormPropConfigById(moduleElement.getPropId());
        JSONObject elementJson = new JSONObject();
        elementJson.put("elType", (Object)this.getRelOrConfigProp(moduleElement.getHtmlType(), element.getHtmlType()));
        elementJson.put("code", (Object)element.getPropCode());
        elementJson.put("col", (Object)Integer.parseInt(moduleElement.getLayout()));
        elementJson.put("label", (Object)element.getPropName());
        elementJson.put("htmlDealCode", (Object)element.getHtmlDealCode());
        elementJson.put("rules", (Object)this.getCheckRules(element.getCheckRule(), moduleElement.getCheckRule()));
        elementJson.put("relevantData", (Object)JSON.parseObject((String)moduleElement.getLinkageRule()));
        this.dealRwTag(elementJson, this.getRelOrConfigProp(moduleElement.getRwTag(), moduleElement.getRwTag()));
        JSONObject dataJson = new JSONObject();
        this.getElementValue(dataJson, element, paramJson);
        Object obj = dataJson.get((Object)"data");
        if (!StringUtils.isEmpty((Object)obj)) {
            if (obj instanceof String) {
                elementJson.put("realValue", (Object)dataJson.getString("data"));
            } else if (obj instanceof JSONObject) {
                elementJson.put("realValue", (Object)dataJson.getJSONObject("data"));
            }
        }
        elementJson.put("dictData", (Object)dataJson.getJSONArray("dictData"));
        elementJson.put("defaultVal", (Object)StringUtils.defaultString((String)dataJson.getString("defaultVal"), (String)element.getDefaultValue()));
        elementJson.put("wrapper", (Object)element.getLayOutType());
        elementJson.put("sequence", (Object)moduleElement.getSequence());
        if (elementJson.get((Object)"realValue") != null) {
            elementArray.add((Object)elementJson);
        }
    }

    private JSONArray getCheckRules(String formPropConfigRule, String formModulePropRelRule) {
        JSONArray propRelRule = JSON.parseArray((String)formModulePropRelRule);
        JSONArray propConfigRule = JSON.parseArray((String)formPropConfigRule);
        if (StringUtils.isEmpty((Collection)propRelRule)) {
            propRelRule = new JSONArray();
        }
        if (StringUtils.isEmpty((Collection)propConfigRule)) {
            propConfigRule = new JSONArray();
        }
        propRelRule.addAll((Collection)propConfigRule);
        return propRelRule;
    }

    protected void dealSubModule(JSONArray components, JSONObject paramJson, List<FormTemplateModuleRel> list) {
        for (FormTemplateModuleRel templateModule : list) {
            Long id;
            String moduleFactors = templateModule.getFactors();
            if (!this.factorExpressionService.isShowCurrentElement(moduleFactors, paramJson, id = templateModule.getId(), "module")) continue;
            String receiptRelCode = templateModule.getReceiptRelCode();
            if (StringUtils.isNotEmpty((String)receiptRelCode)) {
                paramJson.put("pathParams", (Object)receiptRelCode);
            }
            IBuildModuleClassProcessor processor = (IBuildModuleClassProcessor)SpringUtils.getBean((String)templateModule.getClassName());
            processor.build(components, templateModule, paramJson);
            paramJson.remove((Object)"pathParams");
        }
    }

    protected void dealRwTag(JSONObject element, String rwTag) {
        if (StringUtils.isNotEmpty((String)rwTag)) {
            String[] split = rwTag.split("&");
            String type = split[0];
            if ("02".equals(type) || "03".equals(type)) {
                element.put("disabled", (Object)true);
            } else if ("05".equals(type)) {
                element.put("isShow", (Object)false);
            } else if ("06".equals(type)) {
                element.put("disType", (Object)"text");
            }
            if (split.length > 1) {
                if ("10".equals(split[1])) {
                    element.put("isBtnBarEl", (Object)true);
                } else if ("11".equals(split[1])) {
                    element.put("isBtnBarEl", (Object)false);
                }
            }
        }
    }

    protected String getRelOrConfigProp(String propRel, String propConfig) {
        return StringUtils.isNotEmpty((String)propRel) ? propRel : propConfig;
    }

    protected void getElementValue(JSONObject dataJson, FormPropConfig element, JSONObject paramJson) {
        String valueDependClass;
        String dependClass = element.getDependClass();
        if (StringUtils.isNotEmpty((String)dependClass) && StringUtils.isNotEmpty((String)element.getDependField())) {
            IBuildPathDependClassProcessor processor = (IBuildPathDependClassProcessor)SpringUtils.getBean((String)dependClass);
            processor.build(element, paramJson, dataJson);
        }
        if (StringUtils.isNotEmpty((String)(valueDependClass = element.getValueDependClass())) && StringUtils.isNotEmpty((String)element.getValueDependField())) {
            IBuildValueDependClassProcessor valueProcessor = (IBuildValueDependClassProcessor)SpringUtils.getBean((String)valueDependClass);
            valueProcessor.build(element.getValueDependField(), dataJson);
        }
    }
}

