/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.processor.build.module;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.processor.build.BaseModuleProcessor;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TableListModuleProcessor
extends BaseModuleProcessor {
    @Autowired
    IFormPropConfigService formPropConfigService;
    @Autowired
    IFormFactorExpressionService factorExpressionService;

    @Override
    protected void dealModuleElements(JSONObject componentJson, List<FormModulePropRel> moduleElements, JSONObject paramJson) {
        int tableDataSize = 0;
        boolean hasSelection = false;
        JSONObject valJson = new JSONObject();
        HashMap<String, String> labelMap = new HashMap<String, String>(16);
        JSONArray colDataArray = new JSONArray();
        for (FormModulePropRel moduleElement : moduleElements) {
            Object id;
            String elementFactors = moduleElement.getFactors();
            if (!this.factorExpressionService.isShowCurrentElement(elementFactors, paramJson, (Long)(id = moduleElement.getId()), "prop")) continue;
            JSONObject colElementJson = new JSONObject();
            FormPropConfig element = this.formPropConfigService.selectFormPropConfigById(moduleElement.getPropId());
            if (element == null) continue;
            JSONObject dataJson = new JSONObject();
            super.getElementValue(dataJson, element, paramJson);
            String jsonType = dataJson.getString("dataType");
            labelMap.put(element.getPropCode(), jsonType);
            if (StringUtils.equals((CharSequence)"array", (CharSequence)jsonType)) {
                JSONArray array = dataJson.getJSONArray("data");
                if (array != null) {
                    if (StringUtils.equals((CharSequence)element.getHtmlType(), (CharSequence)"selection")) {
                        hasSelection = true;
                        tableDataSize = array.size();
                    } else if (!hasSelection) {
                        tableDataSize = Math.max(tableDataSize, array.size());
                    }
                }
                valJson.put(element.getPropCode(), (Object)array);
            } else if (StringUtils.equals((CharSequence)"object", (CharSequence)jsonType)) {
                valJson.put(element.getPropCode(), (Object)dataJson.getString("data"));
            }
            colElementJson.put("type", (Object)element.getHtmlType());
            colElementJson.put("value", (Object)element.getPropCode());
            colElementJson.put("label", (Object)element.getPropName());
            colDataArray.add((Object)colElementJson);
        }
        JSONArray rowDataArray = new JSONArray();
        for (int k = 0; k < tableDataSize; ++k) {
            JSONObject rowData = new JSONObject();
            for (String key : labelMap.keySet()) {
                if (StringUtils.equals((CharSequence)"array", (CharSequence)((CharSequence)labelMap.get(key)))) {
                    JSONArray array = valJson.getJSONArray(key);
                    if (array == null) {
                        rowData.put(key, (Object)"");
                        continue;
                    }
                    if (k > array.size() - 1) {
                        rowData.put(key, (Object)"");
                        continue;
                    }
                    rowData.put(key, array.get(k));
                    continue;
                }
                if (StringUtils.equals((CharSequence)"object", (CharSequence)((CharSequence)labelMap.get(key)))) {
                    rowData.put(key, (Object)valJson.getString(key));
                    continue;
                }
                rowData.put(key, (Object)"");
            }
            rowDataArray.add((Object)rowData);
        }
        JSONObject elementJson = new JSONObject();
        elementJson.put("colData", (Object)colDataArray);
        elementJson.put("elType", (Object)"multipleTable");
        elementJson.put("tableData", (Object)rowDataArray);
        JSONArray elementArray = new JSONArray();
        elementArray.add((Object)elementJson);
        componentJson.put("elements", (Object)elementArray);
    }

    @Override
    protected void dealModuleElement(JSONArray elementArray, FormModulePropRel moduleElement, JSONObject paramJson) {
        throw new UnsupportedOperationException();
    }
}

