/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.core.redis.RedisCache;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormCommonService;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormModulePropRelService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class FormCommonServiceImpl
implements IFormCommonService {
    private static final String REL_ID = "relId";
    private static final String FACTOR_TYPE = "factorType";
    private static final String FORM_PROP_CONFIG = "FormRedis_FormPropConfig";
    @Autowired
    IFormTemplateModuleRelService formTemplateModuleRelService;
    @Autowired
    IFormFactorExpressionService formFactorExpressionService;
    @Autowired
    IFormModulePropRelService formModulePropRelService;
    @Autowired
    IFormPropConfigService formPropConfigService;
    @Autowired
    RedisCache redisCache;

    @Override
    public List<FormTemplateModuleRel> getTemplateModuleRels(Long tmplId, JSONObject input) {
        ArrayList<FormTemplateModuleRel> templateModules = new ArrayList<FormTemplateModuleRel>();
        List<FormTemplateModuleRel> templateModuleRels = this.formTemplateModuleRelService.selectParentFormTemplateModuleRelByTmplId(tmplId);
        JSONObject factor = input.getJSONObject("factor");
        String dealType = factor.getString("dealType");
        for (FormTemplateModuleRel formTemplateModuleRel : templateModuleRels) {
            if (StringUtils.isNotEmpty((String)dealType) && !dealType.equals(formTemplateModuleRel.getDealType())) continue;
            String factors = formTemplateModuleRel.getFactors();
            if (StringUtils.isNotEmpty((String)factors)) {
                Long id = formTemplateModuleRel.getId();
                input.put(REL_ID, (Object)id);
                input.put(FACTOR_TYPE, (Object)"module");
                if (!this.formFactorExpressionService.getFactorResultByExpression(factors, input)) continue;
            }
            templateModules.add(formTemplateModuleRel);
        }
        return templateModules;
    }

    @Override
    public List<FormModulePropRel> getFormModulePropRels(Long moduleId, JSONObject input) {
        FormModulePropRel formModulePropRelQuery = new FormModulePropRel();
        formModulePropRelQuery.setModuleId(moduleId);
        List<FormModulePropRel> formModulePropRels = this.formModulePropRelService.selectFormModulePropRelList(formModulePropRelQuery);
        for (FormModulePropRel formModulePropRel : formModulePropRels) {
            String propFactors = formModulePropRel.getFactors();
            if (!StringUtils.isNotEmpty((String)propFactors)) continue;
            Long id = formModulePropRel.getId();
            input.put(REL_ID, (Object)id);
            input.put(FACTOR_TYPE, (Object)"prop");
            if (this.formFactorExpressionService.getFactorResultByExpression(propFactors, input)) continue;
            formModulePropRels.remove((Object)formModulePropRel);
        }
        return formModulePropRels;
    }

    @Override
    public FormPropConfig getFormPropConfig(Long propId) {
        String key = FORM_PROP_CONFIG + propId;
        FormPropConfig formPropConfig = (FormPropConfig)((Object)JSON.parseObject((String)((String)this.redisCache.getCacheObject(key)), FormPropConfig.class));
        if (StringUtils.isEmpty((Object)((Object)formPropConfig))) {
            formPropConfig = this.formPropConfigService.selectFormPropConfigById(propId);
            this.redisCache.setCacheObject(key, (Object)formPropConfig, Integer.valueOf(1), TimeUnit.DAYS);
        }
        return formPropConfig;
    }
}

