/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service;

import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormFactorRefService;
import com.chinaj.engine.form.api.IFormFactorService;
import com.chinaj.engine.form.common.FactorExpressionUtil;
import com.chinaj.engine.form.domain.FormFactor;
import com.chinaj.engine.form.processor.build.AbstractFactor;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormFactorExpressionServiceImpl
implements IFormFactorExpressionService {
    private static final Logger log = LoggerFactory.getLogger(FormFactorExpressionServiceImpl.class);
    @Autowired
    private IFormFactorRefService formFactorRefService;
    @Autowired
    private IFormFactorService formFactorService;

    @Override
    public boolean isShowCurrentElement(String factors, JSONObject paramJson, Long id, String foctorType) {
        if (StringUtils.isNotEmpty((String)factors)) {
            paramJson.put("relId", (Object)id);
            paramJson.put("factorType", (Object)foctorType);
            if (!this.getFactorResultByExpression(factors, paramJson)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean getFactorResultByExpression(String factorsExpression, JSONObject json) {
        List<String> list = FactorExpressionUtil.dealMiddleExpression(factorsExpression);
        return this.dealSuffixExpression(list, json);
    }

    private boolean dealSuffixExpression(List<String> suffixExpressionList, JSONObject json) {
        ArrayDeque<Object> stackDeque = new ArrayDeque<Object>();
        for (String suffixExpression : suffixExpressionList) {
            if (FactorExpressionUtil.isOperatorExceptNot(suffixExpression) && stackDeque.size() >= 2) {
                stackDeque.push(this.calculationExpression(stackDeque.pop(), stackDeque.pop(), suffixExpression, json));
                continue;
            }
            if ("!".equals(suffixExpression) && !stackDeque.isEmpty()) {
                stackDeque.push(this.calculationExpression(stackDeque.pop(), suffixExpression, json));
                continue;
            }
            stackDeque.push(suffixExpression);
        }
        if (!stackDeque.isEmpty()) {
            Object pop = stackDeque.pop();
            return this.calculationExpression(pop, json);
        }
        return false;
    }

    private boolean calculationExpression(Object objectOne, Object objectTwo, String operator, JSONObject factorInfo) {
        boolean dataOne = false;
        boolean dataTwo = false;
        if (objectOne instanceof Boolean) {
            dataOne = Boolean.parseBoolean(objectOne.toString());
        }
        if (objectTwo instanceof Boolean) {
            dataTwo = Boolean.parseBoolean(objectTwo.toString());
        }
        if (objectOne instanceof String) {
            dataOne = this.getFactorResultStatus(objectOne.toString(), factorInfo);
        }
        if (objectTwo instanceof String) {
            dataTwo = this.getFactorResultStatus(objectTwo.toString(), factorInfo);
        }
        if ("&".equals(operator)) {
            return dataOne && dataTwo;
        }
        return dataOne || dataTwo;
    }

    private boolean calculationExpression(Object objectOne, JSONObject factorInfo) {
        return this.calculationExpression(objectOne, null, factorInfo);
    }

    private boolean calculationExpression(Object objectOne, String operator, JSONObject factorInfo) {
        boolean dataOne = false;
        if (objectOne instanceof Boolean) {
            dataOne = Boolean.parseBoolean(objectOne.toString());
        }
        if (objectOne instanceof String) {
            dataOne = this.getFactorResultStatus(objectOne.toString(), factorInfo);
        }
        if ("!".equals(operator)) {
            return !dataOne;
        }
        return dataOne;
    }

    private boolean getFactorResultStatus(String element, JSONObject json) {
        boolean result = true;
        Long factorId = Long.parseLong(element);
        json.put("factorId", (Object)factorId);
        JSONObject factorRel = this.formFactorRefService.getFactorRel(json);
        String factorConfigValue = factorRel.getString(StringUtils.killNull((Object)factorId));
        JSONObject factorRealValue = this.getFactorValue(factorId, json);
        if (StringUtils.isNotEmpty((String)factorConfigValue) && StringUtils.isNotEmpty((Map)factorRealValue)) {
            result = factorConfigValue.contains(StringUtils.killNull((Object)factorRealValue.getString(StringUtils.killNull((Object)factorId))));
        }
        return result;
    }

    private JSONObject getFactorValue(Long factorId, JSONObject factorInfo) {
        JSONObject info = new JSONObject();
        FormFactor formFactor = this.formFactorService.selectFormFactorById(factorId);
        String className = formFactor.getClassName();
        try {
            AbstractFactor processor = (AbstractFactor)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            info.put(StringUtils.killNull((Object)factorId), (Object)processor.getFactorValue(factorInfo));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f71\u54cd\u56e0\u7d20\u4fe1\u606f\u5931\u8d25" + className + "\uff1a{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return info;
    }
}

