/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormFactorRefService;
import com.chinaj.engine.form.domain.FormFactorRef;
import com.chinaj.engine.form.mapper.FormFactorRefMapper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="formFactorRefService")
public class FormFactorRefServiceImpl
implements IFormFactorRefService {
    private static final Logger log = LoggerFactory.getLogger(FormFactorRefServiceImpl.class);
    @Autowired
    private FormFactorRefMapper formFactorRefMapper;

    @Override
    public FormFactorRef selectFormFactorRefById(Long id) {
        return this.formFactorRefMapper.selectFormFactorRefById(id);
    }

    @Override
    public List<FormFactorRef> selectFormFactorRefList(FormFactorRef formFactorRef) {
        return this.formFactorRefMapper.selectFormFactorRefList(formFactorRef);
    }

    @Override
    public int insertFormFactorRef(FormFactorRef formFactorRef) {
        return this.formFactorRefMapper.insertFormFactorRef(formFactorRef);
    }

    @Override
    public int updateFormFactorRef(FormFactorRef formFactorRef) {
        return this.formFactorRefMapper.updateFormFactorRef(formFactorRef);
    }

    @Override
    public int deleteFormFactorRefByIds(Long[] ids) {
        return this.formFactorRefMapper.deleteFormFactorRefByIds(ids);
    }

    @Override
    public int deleteFormFactorRefById(Long id) {
        return this.formFactorRefMapper.deleteFormFactorRefById(id);
    }

    @Override
    public JSONObject getFactorRel(JSONObject json) {
        JSONObject factorRel = new JSONObject();
        String factorType = (String)JSONPath.eval((Object)json, (String)"$.factorType");
        Long factorId = (Long)JSONPath.eval((Object)json, (String)"$.factorId");
        Long relId = (Long)JSONPath.eval((Object)json, (String)"$.relId");
        FormFactorRef formFactorRef = new FormFactorRef();
        formFactorRef.setFactorId(factorId);
        formFactorRef.setRelId(relId);
        formFactorRef.setFactorType(factorType);
        try {
            List<FormFactorRef> refList = this.selectFormFactorRefList(formFactorRef);
            for (FormFactorRef rel : refList) {
                factorRel.put(StringUtils.killNull((Object)factorId), (Object)rel.getFactorValues());
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5f71\u54cd\u56e0\u7d20\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return factorRel;
    }
}

