/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.common.utils.spring.SpringUtils;
import com.chinaj.core.common.RedisUtil;
import com.chinaj.engine.form.api.IFormCommonService;
import com.chinaj.engine.form.api.IFormFactorExpressionService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.api.IFormTemplateService;
import com.chinaj.engine.form.api.ITemplateService;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.domain.FormTemplate;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import com.chinaj.engine.form.processor.IBuildModuleClassProcessor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="templateService")
@Transactional(readOnly=true)
public class TemplateServiceImpl
implements ITemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    IFormCommonService commonService;
    @Autowired
    IFormTemplateService templateService;
    @Autowired
    IFormTemplateModuleRelService templateModuleService;
    @Autowired
    IFormFactorExpressionService factorExpressionService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public JSONObject getTemplate(String viewCode, JSONObject factor, JSONObject data) {
        log.info("\u8fdb\u5165---getTemplate-------viewCode : {}", (Object)viewCode);
        log.info("\u8fdb\u5165---getTemplate-------factor : {}", (Object)factor);
        log.info("\u8fdb\u5165---getTemplate-------data : {}", (Object)data);
        return this.dealTemplate(viewCode, factor, data);
    }

    @Override
    public JSONObject dealTemplate(String viewCode, JSONObject factor, JSONObject data) {
        FormTemplate template = this.templateService.selectFormTemplateByTmplCode(viewCode);
        if (template != null && factor != null) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("data", (Object)data);
            paramJson.put("factor", (Object)factor);
            JSONObject templateJson = new JSONObject();
            List<FormTemplateModuleRel> templateModules = JSON.parseArray((String)this.redisUtil.getRedis("FormRedis:FormTemplateModuleRel" + template.getId()), FormTemplateModuleRel.class);
            if (templateModules == null || templateModules.isEmpty()) {
                templateModules = this.templateModuleService.selectParentFormTemplateModuleRelByTmplId(template.getId());
                this.redisUtil.setRedis("FormRedis:FormTemplateModuleRel" + template.getId(), JSON.toJSONString(templateModules), 1L, TimeUnit.HOURS);
            }
            if (templateModules != null && !templateModules.isEmpty()) {
                try {
                    JSONArray componentArray = new JSONArray();
                    for (FormTemplateModuleRel templateModule : templateModules) {
                        String className;
                        String factors = templateModule.getFactors();
                        if (StringUtils.isNotEmpty((String)factors)) {
                            paramJson.put("factorType", (Object)"module");
                            paramJson.put("relId", (Object)templateModule.getId());
                            if (!this.factorExpressionService.getFactorResultByExpression(factors, paramJson)) continue;
                        }
                        if (!StringUtils.isNotEmpty((String)(className = templateModule.getClassName()))) continue;
                        IBuildModuleClassProcessor processor = (IBuildModuleClassProcessor)SpringUtils.getBean((String)className);
                        processor.build(componentArray, templateModule, paramJson);
                    }
                    templateJson.put("components", (Object)componentArray);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5904\u7406\u89c6\u56fe\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getLocalizedMessage(), (Object)e);
                }
            }
            templateJson.put("viewCode", (Object)viewCode);
            templateJson.put("viewName", (Object)template.getTmplName());
            templateJson.put("tmplCode", (Object)template.getTmplCode());
            templateJson.put("tmplName", (Object)template.getTmplName());
            JSONObject mainOrderJsons = new JSONObject();
            mainOrderJsons.put("MainOrder", (Object)data);
            templateJson.put("dataInfo", (Object)mainOrderJsons);
            return templateJson;
        }
        log.error("\u672a\u77e5\u6a21\u677f\u7f16\u7801\u6216\u5f71\u54cd\u56e0\u7d20\u4e3a\u7a7a\u5bf9\u8c61!");
        return new JSONObject();
    }

    @Override
    public JSONArray getReturnProp(String tmplCode, JSONObject factor, JSONObject data) {
        JSONObject input = new JSONObject();
        input.put("factor", (Object)factor);
        input.put("data", (Object)data);
        JSONArray propertyArray = new JSONArray();
        FormTemplate formTemplate = this.templateService.selectFormTemplateByTmplCode(tmplCode);
        List<FormTemplateModuleRel> templateModules = this.commonService.getTemplateModuleRels(formTemplate.getId(), input);
        for (FormTemplateModuleRel templateModule : templateModules) {
            List<FormModulePropRel> moduleProperties = this.commonService.getFormModulePropRels(templateModule.getModuleId(), input);
            for (FormModulePropRel moduleProperty : moduleProperties) {
                FormPropConfig property = this.commonService.getFormPropConfig(moduleProperty.getPropId());
                JSONObject propertyJson = new JSONObject();
                propertyJson.put("propCode", (Object)property.getPropCode());
                propertyJson.put("propName", (Object)property.getPropName());
                propertyJson.put("propType", (Object)property.getHtmlType());
                propertyJson.put("rwTag", (Object)moduleProperty.getRwTag());
                propertyArray.add((Object)propertyJson);
            }
        }
        return propertyArray;
    }
}

