/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.DateUtils;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IBuildGoodAttrsService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.busi.IFormAtomicCompService;
import com.chinaj.engine.form.api.common.ICommonService;
import com.chinaj.engine.form.domain.FormAtomicComp;
import com.chinaj.engine.form.domain.FormPropConfig;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formAtomicCompService")
@Transactional(rollbackFor={Exception.class})
public class FormAtomicCompServiceImpl
implements IFormAtomicCompService {
    private static final Logger log = LoggerFactory.getLogger(FormAtomicCompServiceImpl.class);
    @Autowired
    private IFormPropConfigService formPropConfigService;
    @Autowired
    private IBuildGoodAttrsService BuildGoodAttrsService;
    @Autowired
    private ICommonService commonService;

    @Override
    public JSONArray list(String data) {
        JSONArray array = new JSONArray();
        FormPropConfig config = new FormPropConfig();
        try {
            List<FormPropConfig> formPropConfigs = this.formPropConfigService.selectFormPropConfigList(config);
            if (StringUtils.isNotEmpty(formPropConfigs)) {
                for (FormPropConfig prop : formPropConfigs) {
                    JSONObject obj = new JSONObject();
                    obj.put("id", (Object)prop.getId());
                    String propName = prop.getPropName();
                    obj.put("text", (Object)propName);
                    String propCode = prop.getPropCode();
                    obj.put("name", (Object)propCode);
                    obj.put("compType", (Object)"prop");
                    obj.put("type", (Object)"string");
                    JSONObject schema = new JSONObject();
                    schema.put("title", (Object)propName);
                    schema.put("name", (Object)propCode);
                    String propSource = prop.getPropSource();
                    if (StringUtils.isNotEmpty((String)propSource)) {
                        obj.put("propSource", (Object)this.commonService.getDictDataByTypeAndValue("atomic_source", propSource));
                    }
                    String htmlType = prop.getHtmlType();
                    schema.put("ui:widget", (Object)htmlType);
                    obj.put("schema", (Object)schema);
                    obj.put("setting", (Object)schema);
                    array.add((Object)obj);
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u539f\u5b50\u7ec4\u4ef6\u89c4\u5219\u5931\u8d25\uff1a{}{}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return array;
    }

    @Override
    public JSONArray listAtomicComps(String data) {
        List<FormAtomicComp> formAtomicComps;
        String pageCompType;
        String businessCompType;
        String atomicCompSource;
        String atomicCompType;
        JSONArray array = new JSONArray();
        FormAtomicComp formAtomicComp = new FormAtomicComp();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String atomicCompName = jsonObject.getString("atomicCompName");
        if (StringUtils.isNotEmpty((String)atomicCompName)) {
            formAtomicComp.setPropName(atomicCompName);
        }
        if (StringUtils.isNotEmpty((String)(atomicCompType = jsonObject.getString("atomicCompType")))) {
            formAtomicComp.setPropType(atomicCompType);
        }
        if (StringUtils.isNotEmpty((String)(atomicCompSource = jsonObject.getString("atomicCompSource")))) {
            formAtomicComp.setPropSource(atomicCompSource);
        }
        if (StringUtils.isNotEmpty((String)(businessCompType = jsonObject.getString("businessCompType")))) {
            formAtomicComp.setModuleId(businessCompType);
        }
        if (StringUtils.isNotEmpty((String)(pageCompType = jsonObject.getString("pageCompType")))) {
            formAtomicComp.setTemplateId(pageCompType);
        }
        if (StringUtils.isNotEmpty(formAtomicComps = this.formPropConfigService.listAtomicComps(formAtomicComp))) {
            for (FormAtomicComp prop : formAtomicComps) {
                JSONObject obj = new JSONObject();
                obj.put("propId", (Object)prop.getPropId());
                obj.put("propCode", (Object)prop.getPropCode());
                obj.put("propName", (Object)prop.getPropName());
                obj.put("businessComps", (Object)prop.getModuleName());
                obj.put("propLevel", (Object)prop.getPropLevel());
                obj.put("propStatus", (Object)prop.getPropStatus());
                obj.put("gmtCreate", (Object)DateUtils.dateTime((Date)prop.getGmtCreate()));
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONObject getAtomicComp(Long id) {
        JSONObject obj = new JSONObject();
        FormPropConfig config = this.formPropConfigService.selectFormPropConfigById(id);
        obj.put("propId", (Object)config.getId());
        obj.put("propCode", (Object)config.getPropCode());
        obj.put("propName", (Object)config.getPropName());
        return obj;
    }

    @Override
    public JSONObject saveAtomicComp(String data) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)1);
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        FormPropConfig config = new FormPropConfig();
        config.setPropStatus("01");
        int i = this.formPropConfigService.insertFormPropConfig(config);
        if (i < 0) {
            json.put("status", (Object)i);
            return json;
        }
        return json;
    }

    @Override
    public JSONObject updateAtomicComp(String data) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)1);
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        long id = jsonObject.getLongValue("id");
        FormPropConfig config = this.formPropConfigService.selectFormPropConfigById(id);
        config.setPropStatus("01");
        int i = this.formPropConfigService.insertFormPropConfig(config);
        if (i < 0) {
            json.put("status", (Object)i);
            return json;
        }
        return json;
    }

    @Override
    public JSONObject initAtomicComp(String data) {
        JSONObject json = new JSONObject();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String goodSku = jsonObject.getString("goodSku");
        JSONObject allGoodAttrs = this.BuildGoodAttrsService.findAllGoodAttrs("23423");
        JSONArray array = allGoodAttrs.getJSONArray("array");
        for (int j = 0; j < array.size(); ++j) {
            String str = array.getString(j);
            FormAtomicComp atomicComp = (FormAtomicComp)((Object)JSONObject.parseObject((String)str, FormAtomicComp.class));
            FormPropConfig config = new FormPropConfig();
            config.setPropCode(atomicComp.getPropCode());
            config.setPropName(atomicComp.getPropName());
            config.setPropSource(atomicComp.getPropSource());
            config.setPropStatus(atomicComp.getPropStatus());
            config.setHtmlType(atomicComp.getPropType());
            config.setPropStatus("01");
            int i = this.formPropConfigService.insertFormPropConfig(config);
            if (i >= 0) continue;
            json.put("status", (Object)i);
            return json;
        }
        return json;
    }

    @Override
    public JSONObject deleteAtomicComp(Long id) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)1);
        FormPropConfig config = this.formPropConfigService.selectFormPropConfigById(id);
        config.setPropStatus("03");
        int i = this.formPropConfigService.updateFormPropConfig(config);
        if (i < 0) {
            json.put("status", (Object)i);
            return json;
        }
        return json;
    }

    @Override
    public JSONObject deployAtomicComp(Long id) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)1);
        FormPropConfig config = this.formPropConfigService.selectFormPropConfigById(id);
        config.setPropStatus("02");
        int i = this.formPropConfigService.updateFormPropConfig(config);
        if (i < 0) {
            json.put("status", (Object)i);
            return json;
        }
        return json;
    }
}

