/*
 * Decompiled with CFR 0.152.
 */
package com.chinaj.engine.form.service.busi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.chinaj.common.utils.DateUtils;
import com.chinaj.common.utils.StringUtils;
import com.chinaj.engine.form.api.IFormModulePropRelService;
import com.chinaj.engine.form.api.IFormModuleService;
import com.chinaj.engine.form.api.IFormPropConfigService;
import com.chinaj.engine.form.api.IFormTemplateModuleRelService;
import com.chinaj.engine.form.api.busi.IFormBusinessCompService;
import com.chinaj.engine.form.api.common.ICommonService;
import com.chinaj.engine.form.domain.FormBusinessComp;
import com.chinaj.engine.form.domain.FormModule;
import com.chinaj.engine.form.domain.FormModulePropRel;
import com.chinaj.engine.form.domain.FormPropConfig;
import com.chinaj.engine.form.domain.FormTemplateModuleRel;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="formBusinessCompService")
@Transactional(rollbackFor={Exception.class})
public class FormBusinessCompServiceImpl
implements IFormBusinessCompService {
    private static final Logger log = LoggerFactory.getLogger(FormBusinessCompServiceImpl.class);
    @Autowired
    private IFormPropConfigService formPropConfigService;
    @Autowired
    private IFormModuleService formModuleService;
    @Autowired
    private IFormModulePropRelService formModulePropRelService;
    @Autowired
    private IFormTemplateModuleRelService formTemplateModuleRelService;
    @Autowired
    private ICommonService commonService;

    @Override
    public JSONArray list(String data) {
        JSONArray array = new JSONArray();
        FormModule module = new FormModule();
        List<FormModule> formModules = this.formModuleService.selectFormModuleList(module);
        if (StringUtils.isNotEmpty(formModules)) {
            for (FormModule formModule : formModules) {
                JSONObject obj = new JSONObject();
                Long id = formModule.getId();
                obj.put("moduleId", (Object)id);
                String moduleName = formModule.getModuleName();
                obj.put("text", (Object)moduleName);
                String moduleCode = formModule.getModuleCode();
                obj.put("name", (Object)moduleCode);
                obj.put("description", (Object)formModule.getRemark());
                obj.put("compType", (Object)"module");
                obj.put("type", (Object)"object");
                JSONObject schema = new JSONObject();
                schema.put("title", (Object)moduleName);
                schema.put("type", (Object)moduleName);
                this.dealBusinessComp(formModule, schema);
                obj.put("propSource", (Object)schema.getString("propSource"));
                obj.put("schema", (Object)schema);
                obj.put("setting", (Object)schema);
                array.add((Object)obj);
            }
        }
        System.out.println(JSONObject.toJSONString((Object)array));
        return array;
    }

    @Override
    public void dealBusinessComp(FormModule formModule, JSONObject properties) {
        properties.put("moduleId", (Object)formModule.getId());
        properties.put("title", (Object)formModule.getModuleName());
        properties.put("description", (Object)formModule.getRemark());
        properties.put("compType", (Object)"module");
        properties.put("type", (Object)"object");
        JSONObject json = new JSONObject();
        Long id = formModule.getId();
        FormModulePropRel formModulePropRel = new FormModulePropRel();
        formModulePropRel.setModuleId(id);
        List<FormModulePropRel> formModulePropRels = this.formModulePropRelService.selectFormModulePropRelList(formModulePropRel);
        if (StringUtils.isNotEmpty(formModulePropRels)) {
            for (FormModulePropRel rel : formModulePropRels) {
                JSONObject obj = new JSONObject();
                Long propId = rel.getPropId();
                FormPropConfig config = this.formPropConfigService.selectFormPropConfigById(propId);
                obj.put("propId", (Object)propId);
                obj.put("title", (Object)config.getPropName());
                obj.put("ui:widget", (Object)rel.getHtmlType());
                obj.put("sequence", (Object)rel.getSequence());
                String propSource = config.getPropSource();
                if (StringUtils.isNotEmpty((String)propSource)) {
                    obj.put("propSource", (Object)this.commonService.getDictDataByTypeAndValue("atomic_source", propSource));
                    properties.put("propSource", (Object)this.commonService.getDictDataByTypeAndValue("atomic_source", propSource));
                }
                obj.put("type", (Object)"string");
                obj.put("compType", (Object)"prop");
                obj.put("name", (Object)config.getPropCode());
                obj.put("description", (Object)config.getRemark());
                json.put(config.getPropCode(), (Object)obj);
            }
        }
        FormTemplateModuleRel formTemplateModuleRel = new FormTemplateModuleRel();
        formTemplateModuleRel.setParentModule(String.valueOf(id));
        List<FormTemplateModuleRel> list = this.formTemplateModuleRelService.selectFormTemplateModuleRelList(formTemplateModuleRel);
        if (StringUtils.isNotEmpty(list)) {
            for (FormTemplateModuleRel templateModuleRel : list) {
                Long moduleId = templateModuleRel.getModuleId();
                FormModule module = this.formModuleService.selectFormModuleById(moduleId);
                this.dealBusinessComp(module, json);
            }
        }
        properties.put("properties", (Object)json);
    }

    @Override
    public JSONArray getBusinessCompType() {
        JSONArray array = new JSONArray();
        FormModule module = new FormModule();
        List<FormModule> formModules = this.formModuleService.selectFormModuleList(module);
        if (StringUtils.isNotEmpty(formModules)) {
            for (FormModule formModule : formModules) {
                JSONObject obj = new JSONObject();
                obj.put("value", (Object)formModule.getId());
                obj.put("label", (Object)formModule.getModuleName());
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONArray listBusinessComps(String data) {
        List<FormBusinessComp> formBusinessComps;
        String pageCompType;
        JSONArray array = new JSONArray();
        FormBusinessComp formBusinessComp = new FormBusinessComp();
        JSONObject jsonObject = JSONObject.parseObject((String)data);
        String businessCompName = jsonObject.getString("businessCompName");
        if (StringUtils.isNotEmpty((String)businessCompName)) {
            formBusinessComp.setModuleName(businessCompName);
        }
        if (StringUtils.isNotEmpty((String)(pageCompType = jsonObject.getString("pageComps")))) {
            formBusinessComp.setTemplateId(pageCompType);
        }
        if (StringUtils.isNotEmpty(formBusinessComps = this.formModuleService.listBusinessComps(formBusinessComp))) {
            for (FormBusinessComp prop : formBusinessComps) {
                JSONObject obj = new JSONObject();
                obj.put("moduleId", (Object)prop.getId());
                obj.put("moduleCode", (Object)prop.getModuleCode());
                obj.put("moduleName", (Object)prop.getModuleName());
                obj.put("pageComps", (Object)prop.getTemplateName());
                obj.put("moduleLevel", (Object)prop.getModuleLevel());
                obj.put("moduleStatus", (Object)prop.getModuleStatus());
                Date gmtCreate = prop.getGmtCreate();
                if (!StringUtils.isEmpty((Object)gmtCreate)) {
                    obj.put("gmtCreate", (Object)DateUtils.dateTime((Date)prop.getGmtCreate()));
                }
                array.add((Object)obj);
            }
        }
        return array;
    }

    @Override
    public JSONObject getBusinessComp(Long id) {
        JSONObject obj = new JSONObject();
        FormModule formModule = this.formModuleService.selectFormModuleById(id);
        obj.put("id", (Object)id);
        String moduleName = formModule.getModuleName();
        obj.put("text", (Object)moduleName);
        String moduleCode = formModule.getModuleCode();
        obj.put("name", (Object)moduleCode);
        obj.put("compType", (Object)"module");
        JSONObject schema = new JSONObject();
        schema.put("title", (Object)moduleName);
        schema.put("type", (Object)"object");
        this.dealBusinessComp(formModule, schema);
        obj.put("schema", (Object)schema);
        obj.put("setting", (Object)schema);
        return obj;
    }

    @Override
    public JSONObject deleteBusinessComp(Long id) {
        JSONObject obj = new JSONObject();
        FormModule module = this.formModuleService.selectFormModuleById(id);
        obj.put("", (Object)module.getId());
        return obj;
    }

    @Override
    public JSONObject copyBusinessComp(Long id) {
        JSONObject obj = new JSONObject();
        FormModule module = this.formModuleService.selectFormModuleById(id);
        obj.put("", (Object)module.getId());
        return obj;
    }

    @Override
    public JSONObject deployBusinessComp(Long id) {
        JSONObject obj = new JSONObject();
        FormModule module = this.formModuleService.selectFormModuleById(id);
        obj.put("", (Object)module.getId());
        return obj;
    }
}

